/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.breakpoints;

import com.sap.jvm.jdi.Location;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BreakpointLocation {
    private final String method;
    private final long codeIndex;
    private final int lineNumber;

    public BreakpointLocation(Location location) {
        this.method = location.method().toString().replaceAll(" ", "");
        this.codeIndex = location.codeIndex();
        this.lineNumber = location.lineNumber();
    }

    public BreakpointLocation(String method, int codeIndex, int lineNumber) {
        this.method = method.replaceAll(" ", "");
        this.codeIndex = codeIndex < 0 ? -1L : (long)codeIndex;
        this.lineNumber = lineNumber < 0 ? -1 : lineNumber;
    }

    public BreakpointLocation(String location) {
        int firstStarIndex = location.indexOf(42);
        int lastStarIndex = location.lastIndexOf(42);
        if (lastStarIndex >= 0 && (lastStarIndex != location.length() - 1 || firstStarIndex != lastStarIndex)) {
            throw new IllegalArgumentException("'*' only allowed at the end: " + location);
        }
        String tmpMethod = location;
        long bci = -1L;
        int line = -1;
        int colon = location.indexOf(58);
        if (colon > 0) {
            tmpMethod = location.substring(0, colon);
            if (colon == location.length() - 1) {
                throw new IllegalArgumentException("Unexpected ':' at the end of location: " + location);
            }
            if (location.charAt(colon + 1) != '<') {
                String lineStr = location.substring(colon + 1);
                int nextColon = location.indexOf(58, colon + 1);
                if (nextColon >= 0) {
                    if (nextColon == location.length() - 1) {
                        throw new IllegalArgumentException("Unexpected ':' at the end of location: " + location);
                    }
                    lineStr = location.substring(colon + 1, nextColon);
                    colon = nextColon;
                    if (location.charAt(colon + 1) != '<') {
                        throw new IllegalArgumentException("Unexpected ':' without code index: " + location);
                    }
                }
                line = Integer.parseInt(lineStr);
            }
            if (location.charAt(colon + 1) == '<') {
                if (location.charAt(location.length() - 1) != '>') {
                    throw new IllegalArgumentException("Incorrect format (missing closing '>'): " + location);
                }
                String codeString = location.substring(colon + 2, location.length() - 1);
                if (!"unknown".equals(codeString)) {
                    bci = Long.parseLong(codeString);
                }
            }
        }
        this.method = tmpMethod;
        this.codeIndex = bci;
        this.lineNumber = line;
    }

    public BreakpointLocation(DataInputStream in) throws IOException {
        this.method = in.readUTF();
        this.codeIndex = in.readLong();
        this.lineNumber = in.readInt();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.method);
        out.writeLong(this.codeIndex);
        out.writeInt(this.lineNumber);
    }

    public String getMethod() {
        return this.method;
    }

    public long getCodeIndex() {
        return this.codeIndex;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean matches(BreakpointLocation other) {
        if (this.method.charAt(this.method.length() - 1) == '*') {
            assert (this.codeIndex == -1L && this.lineNumber == -1);
            return other.method.startsWith(this.method.substring(0, this.method.length() - 1));
        }
        if (other.method.startsWith(this.method)) {
            if (other.method.length() == this.method.length()) {
                return !(this.lineNumber >= 0 && this.lineNumber != other.lineNumber || this.codeIndex >= 0L && this.codeIndex != other.codeIndex);
            }
            assert (this.method.length() < other.method.length());
            if (other.method.charAt(this.method.length()) == '(') {
                return !(this.lineNumber >= 0 && this.lineNumber != other.lineNumber || this.codeIndex >= 0L && this.codeIndex != other.codeIndex);
            }
            int opening = other.method.indexOf(40);
            if (opening < 0) {
                opening = other.method.length();
            }
            if (other.method.charAt(this.method.length()) == '.' && other.method.substring(this.method.length() + 1, opening).indexOf(46) == -1) {
                return !(this.lineNumber >= 0 && this.lineNumber != other.lineNumber || this.codeIndex >= 0L && this.codeIndex != other.codeIndex);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode() ^ (int)(this.codeIndex ^ this.codeIndex >> 32) ^ this.lineNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BreakpointLocation other = (BreakpointLocation)obj;
        return this.codeIndex == other.codeIndex && this.lineNumber == other.lineNumber && this.method.equals(other.method);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.method);
        if (this.lineNumber >= 0) {
            result.append(':');
            result.append(this.lineNumber);
        }
        if (this.codeIndex >= 0L) {
            result.append(":<");
            result.append(this.codeIndex);
            result.append('>');
        }
        return result.toString();
    }
}

