/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller;

import com.sap.jvm.debugging.controller.DebuggingController;
import com.sap.jvm.debugging.controller.FrontendVersion;
import com.sap.jvm.debugging.controller.impl.DebuggingBackendConfiguration;
import com.sap.jvm.debugging.controller.impl.DebuggingControllerImpl;
import com.sap.jvm.debugging.controller.impl.packets.PacketHandlerImpl;
import com.sap.jvm.monitor.cluster.Cluster;
import com.sap.jvm.monitor.vm.DebugState;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.misc.SocketAdapter;
import com.sap.jvm.util.misc.SocketAdapterFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;

public class DebuggingControllerFactory {
    private static boolean performBackendHandshake(SocketAdapter socket, FrontendVersion version) throws IOException {
        int result;
        byte[] handshake = new byte[DebuggingController.JDWP_HANDSHAKE.length];
        int offset = 0;
        for (int length = handshake.length; length > 0; length -= result) {
            result = socket.getInputStream().read(handshake, offset, length);
            if (result < 0) {
                throw new IOException("Connection closed before end of handshake");
            }
            offset += result;
        }
        boolean isSapjvm = Arrays.equals(handshake, DebuggingController.SAPJVM_BACKEND);
        if (!isSapjvm && !Arrays.equals(handshake, DebuggingController.JDWP_HANDSHAKE)) {
            throw new IOException("Received unexpected handshake: " + Arrays.toString(handshake));
        }
        if (isSapjvm) {
            DataInputStream dataIn = new DataInputStream(socket.getInputStream());
            version.setMajorVersion(dataIn.readInt());
            version.setMinorVersion(dataIn.readInt());
        }
        DataOutputStream dataOut = new DataOutputStream(socket.getOutputStream());
        dataOut.write(DebuggingController.SAPJVM_BACKEND);
        if (isSapjvm) {
            dataOut.writeInt(0);
            dataOut.writeInt(2);
        }
        dataOut.flush();
        return isSapjvm;
    }

    private static void connectIfNecessary(PacketHandlerImpl handler, SocketAdapter clientSocket, DebuggingBackendConfiguration config, boolean waitForStart) {
        if (clientSocket != null) {
            handler.connect(clientSocket, waitForStart);
            return;
        }
        int debuggeePort = -1;
        String debuggeeHost = null;
        if (config.getDebuggeePort() > 0 && config.getDebuggeePort() < 65535) {
            debuggeePort = config.getDebuggeePort();
            debuggeeHost = config.getDebuggeeHost() == null ? "localhost" : config.getDebuggeeHost();
        } else if (config.getDefaultDebugPort() > 0 && config.getDefaultDebugPort() < 65535) {
            debuggeePort = config.getDefaultDebugPort();
            debuggeeHost = "localhost";
            if (config.getDebuggeePid() >= 0) {
                DebuggingControllerFactory.openDebugPort(config.getDefaultDebugPort(), config.getDebuggeePid(), -1, -1);
            } else if (config.getDebuggeeSystemNumber() >= 0 && config.getDebuggeeSystemNumber() < 100 && config.getDebuggeeVmId() >= 0) {
                DebuggingControllerFactory.openDebugPort(config.getDefaultDebugPort(), -1, config.getDebuggeeSystemNumber(), config.getDebuggeeVmId());
            } else {
                debuggeePort = -1;
            }
        }
        if (debuggeePort > 0) {
            handler.connect(debuggeeHost, debuggeePort, waitForStart);
        } else if (config.getListenPort() >= 0 && config.getListenPort() < 65535) {
            handler.listen(config.getListenPort(), waitForStart);
        }
    }

    private static void openDebugPort(int port, int processId, int sysNr, int vmId) {
        Vm vm = null;
        if (processId >= 0) {
            vm = Cluster.getVm((int)processId);
        } else {
            Vm[] vms;
            for (Vm obj : vms = Cluster.getVms((int)sysNr)) {
                if (vmId != obj.getVmIndex()) continue;
                vm = obj;
                break;
            }
            if (vm == null) {
                throw new RuntimeException("JVM with id " + vmId + " not found in SAP system " + sysNr);
            }
        }
        try {
            DebugState debugState;
            vm.setDefaultDebugPortRange(new PortRange(port));
            vm.startDebug(SuspendPolicy.SUSPEND_NONE);
            while ((debugState = vm.getDebugInfo().getDebugState()) != DebugState.STATE_WAIT_FOR_DEBUGGER) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (InvalidVmException e) {
            throw new RuntimeException("Opening the debugging port failed", e);
        }
    }

    private static DebuggingController establishConnectionCommon(SocketAdapter serverSocket, SocketAdapter clientSocket, DebuggingBackendConfiguration config, File workspace, String sessionSuffix, boolean waitForStart, FrontendVersion frontendVersion, Object connection) throws IOException {
        String context;
        String string = sessionSuffix != null ? sessionSuffix : (context = workspace == null ? null : new File(workspace, "backend.log"));
        String sessionName = sessionSuffix != null ? sessionSuffix : (workspace == null ? "" : ": " + workspace.getName());
        Trace.get((String)"com.sap.jvm.debugging.controller.version", (Object)context).debug("Connection established: frontend version=%d.%d, backend version=%d.%d", new Object[]{frontendVersion.getMajorVersion(), frontendVersion.getMinorVersion(), 0, 2});
        if (config.isConsole()) {
            String frontendConnection = null;
            if (!(connection instanceof Socket)) {
                frontendConnection = "localhost";
            } else {
                InetSocketAddress inetAddr;
                InetAddress addr;
                SocketAddress address = ((Socket)connection).getRemoteSocketAddress();
                if (address instanceof InetSocketAddress && (addr = (inetAddr = (InetSocketAddress)address).getAddress()) != null) {
                    frontendConnection = addr.getHostAddress() + ":" + inetAddr.getPort();
                }
                if (frontendConnection == null) {
                    frontendConnection = address.toString();
                }
            }
            System.out.println("Debugging frontend connected from " + frontendConnection + ".");
        }
        PacketHandlerImpl handler = new PacketHandlerImpl(context, sessionName, waitForStart);
        DebuggingControllerImpl controller = new DebuggingControllerImpl(serverSocket.getInputStream(), serverSocket.getOutputStream(), handler, frontendVersion, config.getJournalFilePrefix(), workspace, sessionName, context);
        handler.setController(controller);
        DebuggingControllerFactory.connectIfNecessary(handler, clientSocket, config, waitForStart);
        controller.start();
        return controller;
    }

    private static DebuggingController establishConnection(SocketAdapter serverSocket, SocketAdapter clientSocket, DebuggingBackendConfiguration config, File workspace, String sessionSuffix, boolean waitForStart) throws IOException {
        FrontendVersion version;
        if (config.isConsole()) {
            System.out.println("Waiting for connection on port " + config.getBackendPort() + "...");
        }
        if (!DebuggingControllerFactory.performBackendHandshake(serverSocket, version = new FrontendVersion())) {
            serverSocket.close();
            throw new IOException("Frontend is no SAP JVM debugging frontend");
        }
        return DebuggingControllerFactory.establishConnectionCommon(serverSocket, clientSocket, config, workspace, sessionSuffix, waitForStart, version, null);
    }

    public static DebuggingController establishConnection(ServerSocket serverSocket, boolean waitForStart) throws IOException {
        DebuggingBackendConfiguration config = DebuggingBackendConfiguration.getDefault(serverSocket.getLocalPort()).setDebuggee(null, -1);
        return DebuggingControllerFactory.establishConnection(serverSocket, null, config, null, null, waitForStart);
    }

    public static DebuggingController establishConnection(SocketAdapter serverSocket, boolean waitForStart) throws IOException {
        DebuggingBackendConfiguration config = DebuggingBackendConfiguration.getDefault(-1).setDebuggee(null, -1);
        return DebuggingControllerFactory.establishConnection(serverSocket, null, config, null, null, waitForStart);
    }

    public static DebuggingController establishConnection(ServerSocket serverSocket, SocketAdapter clientSocket, DebuggingBackendConfiguration config, File workspace, String sessionSuffix, boolean waitForStart) throws IOException {
        if (config.isConsole()) {
            System.out.println("Waiting for connection on port " + config.getBackendPort() + "...");
        }
        FrontendVersion version = new FrontendVersion();
        Socket socket = null;
        while (!DebuggingControllerFactory.performBackendHandshake(SocketAdapterFactory.getForSocket((Socket)(socket = serverSocket.accept())), version)) {
            socket.close();
        }
        serverSocket.close();
        return DebuggingControllerFactory.establishConnectionCommon(SocketAdapterFactory.getForSocket((Socket)socket), clientSocket, config, workspace, sessionSuffix, waitForStart, version, socket);
    }

    public static void establishConnectionForEclipseLaunching(SocketAdapter serverSocket, SocketAdapter clientSocket, File workspace) throws IOException {
        DebuggingBackendConfiguration config = DebuggingBackendConfiguration.getDefault(-1).setDebuggee(null, -1);
        DebuggingController controller = DebuggingControllerFactory.establishConnection(serverSocket, clientSocket, config, workspace, null, true);
        controller.shutdownOnError(true);
    }

    public static DebuggingController establishConnectionForNeoService(SocketAdapter serverSocket, SocketAdapter clientSocket, FrontendVersion frontendVersion, String sessionSuffix) throws IOException {
        DebuggingBackendConfiguration config = DebuggingBackendConfiguration.getDefault(-1).setDebuggee(null, -1);
        PacketHandlerImpl handler = new PacketHandlerImpl(sessionSuffix, sessionSuffix, false);
        DebuggingControllerImpl controller = new DebuggingControllerImpl(serverSocket.getInputStream(), serverSocket.getOutputStream(), handler, frontendVersion, config.getJournalFilePrefix(), null, sessionSuffix, sessionSuffix);
        handler.setController(controller);
        handler.connect(clientSocket, false);
        controller.shutdownOnError(true);
        controller.start();
        return controller;
    }
}

