/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.tracing.Trace;
import java.util.Arrays;

public final class DebuggingBackendConfiguration {
    private static final String HOST = System.getProperty("com.sap.jvm.debugging.controller.host");
    private static final int PORT = Integer.getInteger("com.sap.jvm.debugging.controller.port", -1);
    private static final int LISTEN_PORT = Integer.getInteger("com.sap.jvm.debugging.controller.listenport", -1);
    private static final int PID = Integer.getInteger("com.sap.jvm.debugging.controller.pid", -1);
    private static final int SYSNR = Integer.getInteger("com.sap.jvm.debugging.controller.sysnr", -1);
    private static final int VMID = Integer.getInteger("com.sap.jvm.debugging.controller.vmid", -1);
    private static final int DEFAULT_PORT = Integer.getInteger("com.sap.jvm.debugging.controller.default.port", 8000);
    private static final String JOURNAL_FILE_PREFIX = System.getProperty("com.sap.jvm.debugging.controller.journal.file");
    private static final CommandLineParser.Option helpOption = new CommandLineParser.OptionalSwitch("h", "help");
    private static final CommandLineParser.Option questionOption = new CommandLineParser.OptionalSwitch("?", "?");
    private static final CommandLineParser.Option backendPortOption = new CommandLineParser.OptionalEqualsOption("p", "port");
    private static final CommandLineParser.Option debuggeeHostOption = new CommandLineParser.OptionalEqualsOption("t", "debuggee_host");
    private static final CommandLineParser.Option debuggeePortOption = new CommandLineParser.OptionalEqualsOption("r", "debuggee_port");
    private static final CommandLineParser.Option pidOption = new CommandLineParser.OptionalEqualsOption("i", "pid");
    private static final CommandLineParser.Option sysnrOption = new CommandLineParser.OptionalEqualsOption("s", "sysnr");
    private static final CommandLineParser.Option vmidOption = new CommandLineParser.OptionalEqualsOption("v", "vmid");
    private static final CommandLineParser.Option defaultDebugPortOption = new CommandLineParser.OptionalEqualsOption("d", "default_debug_port");
    private static final CommandLineParser.Option journalFilePrefixOption = new CommandLineParser.OptionalEqualsOption("j", "journal");
    private static final CommandLineParser.Option listenPortOption = new CommandLineParser.OptionalEqualsOption("l", "listen_port");
    private static final CommandLineParser.Option[] options = new CommandLineParser.Option[]{helpOption, questionOption, backendPortOption, debuggeeHostOption, debuggeePortOption, listenPortOption, pidOption, sysnrOption, vmidOption, defaultDebugPortOption, journalFilePrefixOption};
    private final int backendPort;
    private final String debuggeeHost;
    private final int debuggeePort;
    private final int listenPort;
    private final int debuggeePid;
    private final int debuggeeSysNr;
    private final int debuggeeVmId;
    private final int defaultDebugPort;
    private final String journalFilePrefix;
    private final boolean isConsole;

    private DebuggingBackendConfiguration(int backendPort, String debuggeeHost, int debuggeePort, int listenPort, int debuggeePid, int debuggeeSysNr, int debuggeeVmId, int defaultDebugPort, String journalFilePrefix, boolean isConsole) {
        this.backendPort = backendPort;
        this.debuggeeHost = debuggeeHost;
        this.debuggeePort = debuggeePort;
        this.listenPort = listenPort;
        this.debuggeePid = debuggeePid;
        this.debuggeeSysNr = debuggeeSysNr;
        this.debuggeeVmId = debuggeeVmId;
        this.defaultDebugPort = defaultDebugPort;
        this.journalFilePrefix = journalFilePrefix;
        this.isConsole = isConsole;
    }

    public int getBackendPort() {
        return this.backendPort;
    }

    public String getDebuggeeHost() {
        return this.debuggeeHost;
    }

    public int getDebuggeePort() {
        return this.debuggeePort;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public int getDebuggeePid() {
        return this.debuggeePid;
    }

    public int getDebuggeeSystemNumber() {
        return this.debuggeeSysNr;
    }

    public int getDebuggeeVmId() {
        return this.debuggeeVmId;
    }

    public int getDefaultDebugPort() {
        return this.defaultDebugPort;
    }

    public String getJournalFilePrefix() {
        return this.journalFilePrefix;
    }

    public boolean isConsole() {
        return this.isConsole;
    }

    public DebuggingBackendConfiguration setDebuggee(String host, int port) {
        return new DebuggingBackendConfiguration(this.backendPort, host, port, this.listenPort, this.debuggeePid, this.debuggeeSysNr, this.debuggeeVmId, this.defaultDebugPort, this.journalFilePrefix, this.isConsole);
    }

    public static DebuggingBackendConfiguration create(String[] args) {
        try {
            CommandLineParser parser = new CommandLineParser(args, options, true);
            String[] unparsedStrings = parser.getRemainingArguments();
            if (parser.isOptionSet(helpOption) || parser.isOptionSet(questionOption)) {
                DebuggingBackendConfiguration.printUsage();
                return null;
            }
            if (unparsedStrings.length > 1) {
                System.err.println("Incorrect number of arguments: " + Arrays.toString(args));
                DebuggingBackendConfiguration.printUsage();
                return null;
            }
            int backendPort = -1;
            if (unparsedStrings.length == 1) {
                backendPort = Integer.parseInt(args[0]);
            }
            if ((backendPort = DebuggingBackendConfiguration.parseIntegerOption(parser, backendPortOption, backendPort)) <= 0 || backendPort >= 65535) {
                if (unparsedStrings.length > 0 || parser.isOptionSet(backendPortOption)) {
                    System.err.println("JVM debugger daemon port out of range: " + backendPort);
                } else {
                    System.err.println("No JVM debugger daemon port specified.");
                }
                DebuggingBackendConfiguration.printUsage();
                return null;
            }
            String debuggeeHost = DebuggingBackendConfiguration.parseStringOption(parser, debuggeeHostOption, HOST);
            int debuggeePort = DebuggingBackendConfiguration.parseIntegerOption(parser, debuggeePortOption, PORT);
            int listenPort = DebuggingBackendConfiguration.parseIntegerOption(parser, listenPortOption, LISTEN_PORT);
            int debuggeePid = DebuggingBackendConfiguration.parseIntegerOption(parser, pidOption, PID);
            int debuggeeSysNr = DebuggingBackendConfiguration.parseIntegerOption(parser, sysnrOption, SYSNR);
            int debuggeeVmId = DebuggingBackendConfiguration.parseIntegerOption(parser, vmidOption, VMID);
            int defaultDebugPort = DebuggingBackendConfiguration.parseIntegerOption(parser, defaultDebugPortOption, DEFAULT_PORT);
            String journalFilePrefix = DebuggingBackendConfiguration.parseStringOption(parser, journalFilePrefixOption, JOURNAL_FILE_PREFIX);
            return new DebuggingBackendConfiguration(backendPort, debuggeeHost, debuggeePort, listenPort, debuggeePid, debuggeeSysNr, debuggeeVmId, defaultDebugPort, journalFilePrefix, true);
        }
        catch (CommandLineParser.CommandLineException e) {
            Trace.error((Throwable)e, () -> "Error while parsing command arguments: " + Arrays.toString(args));
            return null;
        }
    }

    public static DebuggingBackendConfiguration getDefault(int backendPort) {
        return new DebuggingBackendConfiguration(backendPort, HOST, PORT, LISTEN_PORT, PID, SYSNR, VMID, DEFAULT_PORT, JOURNAL_FILE_PREFIX, false);
    }

    private static void printUsage() {
        System.out.println("Starts the jvm debugger daemon for high latency network connections.");
        System.out.println();
        System.out.println("Syntax: jvmdebugger-daemon --port=<debugger daemon port> [<options> ...]");
        System.out.println();
        System.out.println("The following options are supported: ");
        System.out.println("-?, --?");
        System.out.println("            Print usage information (this message).");
        System.out.println("-d, --default_debug_port");
        System.out.println("            Defines the default port used for debugging in the debuggee.");
        System.out.println("            This option is only used in conjunction with --pid or --sysnr.");
        System.out.println("            to determine the port to open for debugging in the debuggee.");
        System.out.println("-h, --help");
        System.out.println("            Print usage information (this message).");
        System.out.println("-i, --pid=<process identifier of the debuggee>");
        System.out.println("            Defines the process identifier of the debuggee to connect to.");
        System.out.println("            Debugging is automatically started in the specified process.");
        System.out.println("-j, --journal=<file prefix of the debugging journal files>");
        System.out.println("            Defines the path prefix of the debugging journal files.");
        System.out.println("-l, --listen_port=<port to listen for connection request of the debuggee>");
        System.out.println("            Defines the port to use for listening for connection requests");
        System.out.println("            of the debuggee.");
        System.out.println("-p, --port=<debugger daemon port>");
        System.out.println("            Defines the port to use for the jvm debugger daemon.");
        System.out.println("-r, --debuggee_port=<port of the debuggee>");
        System.out.println("            Defines the port of the debuggee to connect to.");
        System.out.println("            This option requires --debuggee_host to be specified as well.");
        System.out.println("-s, --sysnr=<system number of the debuggee>");
        System.out.println("            Defines the SAP system number of the debuggee to connect to.");
        System.out.println("            Debugging is automatically started in the specified SAP system.");
        System.out.println("            This option requires --vmid to be specified as well.");
        System.out.println("-t, --debuggee_host=<host name or IP address of the debuggee>");
        System.out.println("            Defines the host name or IP address of the debuggee to connect to.");
        System.out.println("            This option requires --debuggee_port to be specified as well.");
        System.out.println("-v, --vmid=<system vm identifier of the debuggee>");
        System.out.println("            Defines the SAP system vm identifier of the debuggee to connect to.");
        System.out.println("            Debugging is automatically started in the specified SAP system.");
        System.out.println("            This option requires --sysnr to be specified as well.");
    }

    private static int parseIntegerOption(CommandLineParser parser, CommandLineParser.Option option, int defaultValue) {
        if (parser.isOptionSet(option)) {
            try {
                return Integer.parseInt(parser.getValue(option));
            }
            catch (NumberFormatException e) {
                Trace.error((Throwable)e, () -> "Error while parsing option " + option.getLongName() + " with value '" + parser.getValue(option) + "'");
            }
        }
        return defaultValue;
    }

    private static String parseStringOption(CommandLineParser parser, CommandLineParser.Option option, String defaultValue) {
        if (parser.isOptionSet(option)) {
            return parser.getValue(option);
        }
        return defaultValue;
    }
}

