/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl;

import com.sap.jvm.debugging.controller.DebuggingController;
import com.sap.jvm.debugging.controller.FrontendVersion;
import com.sap.jvm.debugging.controller.io.PacketDispatcher;
import com.sap.jvm.debugging.controller.io.PacketFileWriter;
import com.sap.jvm.debugging.controller.io.PacketReader;
import com.sap.jvm.debugging.controller.io.PacketWriter;
import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.tasks.TaskExecutor;
import com.sap.jvm.debugging.presentation.BreakpointListModel;
import com.sap.jvm.debugging.presentation.ExpressionVariableTreeModel;
import com.sap.jvm.debugging.presentation.LocalVariableTreeModel;
import com.sap.jvm.debugging.presentation.ThreadListModel;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public final class DebuggingControllerImpl
implements DebuggingController {
    private final String journalFilePrefix;
    private final PacketReader reader;
    private final Thread readerThread;
    private final PacketWriter writer;
    private final Thread writerThread;
    private final PacketDispatcher dispatcher;
    private final Thread dispatcherThread;
    private final TaskExecutor executor;
    private final Thread executorThread;
    private final PacketFileWriter readPacketsWriter;
    private final Thread readPacketsWriterThread;
    private final PacketFileWriter writtenPacketsWriter;
    private final Thread writtenPacketsWriterThread;
    private final BlockingQueue<DebuggingPacket> readQueue;
    private final BlockingQueue<DebuggingPacket> writeQueue;
    private final BlockingQueue<Runnable> taskQueue;
    private final BlockingQueue<DebuggingPacket> readJournalQueue;
    private final BlockingQueue<DebuggingPacket> writeJournalQueue;
    private final PacketHandler handler;
    private final LocalVariableTreeModel localVariables;
    private final ExpressionVariableTreeModel expressionVariables;
    private final ExpressionVariableTreeModel hoverExpressionVariables;
    private final ThreadListModel threads;
    private final BreakpointListModel breakpoints;
    private final int majorFrontendVersion;
    private final int minorFrontendVersion;
    private final Tracer tracer;
    private volatile boolean finished = false;
    private final PacketReader.PacketReaderListener errorListener = new PacketReader.PacketReaderListener(){

        @Override
        public void finished(IOException exception) {
            try {
                DebuggingControllerImpl.this.stop();
            }
            catch (IOException e) {
                DebuggingControllerImpl.this.tracer.error((Throwable)e, "Shutting down debugging backend failed.");
            }
        }
    };

    public DebuggingControllerImpl(InputStream in, OutputStream out, PacketHandler callback, FrontendVersion frontendVersion, String journalPrefix, File workspace, String sessionSuffix, Object context) {
        if (!frontendVersion.isSupported()) {
            int majorVersion = frontendVersion.getMajorVersion();
            int minorVersion = frontendVersion.getMinorVersion();
            String message = majorVersion > 0 || majorVersion == 0 && minorVersion > 2 ? "Debugging frontend too new: Please update backend" : "Debugging frontend too old: Please update frontend";
            throw new RuntimeException(message + " (frontend=" + majorVersion + "." + minorVersion + ", backend=" + 0 + "." + 2 + ")");
        }
        String separator = File.separator;
        String sessionName = sessionSuffix == null ? "" : sessionSuffix;
        this.tracer = Trace.get((String)"com.sap.jvm.debugging.controller", (Object)context);
        this.journalFilePrefix = workspace == null ? journalPrefix : workspace + separator + "backend-packets";
        this.readQueue = new LinkedBlockingQueue<DebuggingPacket>();
        this.writeQueue = new LinkedBlockingQueue<DebuggingPacket>();
        this.taskQueue = new LinkedBlockingQueue<Runnable>();
        this.handler = callback;
        LinkedBlockingQueue<DebuggingPacket> tmpReadJournal = null;
        PacketFileWriter tmpReadJournalWriter = null;
        Thread tmpReadJournalThread = null;
        LinkedBlockingQueue<DebuggingPacket> tmpWriteJournal = null;
        PacketFileWriter tmpWriteJournalWriter = null;
        Thread tmpWriteJournalThread = null;
        if (this.journalFilePrefix != null) {
            LinkedBlockingQueue<DebuggingPacket> tmp = new LinkedBlockingQueue<DebuggingPacket>();
            try {
                tmpReadJournalWriter = new PacketFileWriter(this.journalFilePrefix + ".read.gz", tmp);
                tmpReadJournalThread = new Thread((Runnable)tmpReadJournalWriter, "JournalWriter (read packets, backend)" + sessionName);
                tmpReadJournal = tmp;
            }
            catch (IOException e) {
                this.tracer.error((Throwable)e, "Exception while creating read journal writer");
            }
            tmp = new LinkedBlockingQueue();
            try {
                tmpWriteJournalWriter = new PacketFileWriter(this.journalFilePrefix + ".write.gz", tmp);
                tmpWriteJournalThread = new Thread((Runnable)tmpWriteJournalWriter, "JournalWriter (written packets, backend)" + sessionName);
                tmpWriteJournal = tmp;
            }
            catch (IOException e) {
                this.tracer.error((Throwable)e, "Exception while creating write journal writer");
            }
        }
        this.readJournalQueue = tmpReadJournal;
        this.readPacketsWriter = tmpReadJournalWriter;
        this.readPacketsWriterThread = tmpReadJournalThread;
        this.writeJournalQueue = tmpWriteJournal;
        this.writtenPacketsWriter = tmpWriteJournalWriter;
        this.writtenPacketsWriterThread = tmpWriteJournalThread;
        this.reader = new PacketReader(in, this.readQueue, this.readJournalQueue, context);
        this.writer = new PacketWriter(out, this.writeQueue, this.writeJournalQueue, context);
        this.readerThread = new Thread((Runnable)this.reader, "PacketReader (backend)" + sessionName);
        this.writerThread = new Thread((Runnable)this.writer, "PacketWriter (backend)" + sessionName);
        this.dispatcher = new PacketDispatcher(this.readQueue, this.taskQueue, this.handler, context);
        this.dispatcherThread = new Thread((Runnable)this.dispatcher, "PacketDispatcher (backend)" + sessionName);
        this.executor = new TaskExecutor(this.taskQueue, context);
        this.executorThread = new Thread((Runnable)this.executor, "TaskExecutor (backend)" + sessionName);
        this.threads = new ThreadListModel();
        this.localVariables = new LocalVariableTreeModel(this.threads);
        this.expressionVariables = new ExpressionVariableTreeModel(this.localVariables, this.threads);
        this.hoverExpressionVariables = new ExpressionVariableTreeModel(this.localVariables, this.threads);
        this.breakpoints = new BreakpointListModel();
        this.majorFrontendVersion = frontendVersion.getMajorVersion();
        this.minorFrontendVersion = frontendVersion.getMinorVersion();
    }

    public void start() {
        this.readerThread.start();
        this.writerThread.start();
        this.dispatcherThread.start();
        this.executorThread.start();
        if (this.journalFilePrefix != null) {
            this.readPacketsWriterThread.start();
            this.writtenPacketsWriterThread.start();
        }
    }

    @Override
    public void stop() throws IOException {
        this.finished = true;
        IOException exception = null;
        this.handler.close();
        this.reader.stop();
        try {
            this.writer.stop();
        }
        catch (IOException e) {
            exception = e;
        }
        this.dispatcher.stop();
        this.executor.stop();
        if (this.journalFilePrefix != null) {
            this.readPacketsWriter.stop();
            this.writtenPacketsWriter.stop();
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void finishJournal() {
        if (this.journalFilePrefix != null) {
            this.readPacketsWriter.stop();
            this.writtenPacketsWriter.stop();
            while (!this.readPacketsWriter.isFinished() || !this.writtenPacketsWriter.isFinished()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public BlockingQueue<DebuggingPacket> getWriteQueue() {
        return this.writeQueue;
    }

    @Override
    public BlockingQueue<Runnable> getTaskQueue() {
        return this.taskQueue;
    }

    @Override
    public ThreadListModel getThreads() {
        return this.threads;
    }

    @Override
    public LocalVariableTreeModel getLocals() {
        return this.localVariables;
    }

    @Override
    public ExpressionVariableTreeModel getExpressions() {
        return this.expressionVariables;
    }

    @Override
    public ExpressionVariableTreeModel getHoverExpressions() {
        return this.hoverExpressionVariables;
    }

    @Override
    public BreakpointListModel getBreakpoints() {
        return this.breakpoints;
    }

    @Override
    public boolean isInTaskExecution() {
        return Thread.currentThread() == this.executorThread;
    }

    @Override
    public int getMajorFrontendVersion() {
        return this.majorFrontendVersion;
    }

    @Override
    public int getMinorFrontendVersion() {
        return this.minorFrontendVersion;
    }

    @Override
    public void shutdownOnError(boolean shutdown) {
        this.reader.removeListener(this.errorListener);
        if (shutdown) {
            this.reader.addListener(this.errorListener);
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

