/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.controller.packets.variables.VariableTreePacket;
import com.sap.jvm.debugging.presentation.AbstractVariableTreeModel;
import com.sap.jvm.debugging.presentation.Variable;
import com.sap.jvm.debugging.presentation.VisibilityType;
import com.sap.jvm.debugging.types.ThreadHandle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractVariableTreePacket
implements VariableTreePacket {
    private static final VariableNodeImpl[] NO_CHILDREN = new VariableNodeImpl[0];
    private final long threadId;
    private final int frameIndex;
    private final VariableNodeImpl[] locals;
    private final String stringOfSelection;

    protected AbstractVariableTreePacket(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
        this.frameIndex = in.readInt();
        this.stringOfSelection = in.readUTF();
        int size = in.readInt();
        this.locals = size == 0 ? NO_CHILDREN : new VariableNodeImpl[size];
        for (int i = 0; i < size; ++i) {
            this.locals[i] = new VariableNodeImpl(in);
        }
    }

    public AbstractVariableTreePacket(AbstractVariableTreeModel variables, ThreadHandle thread) {
        this.threadId = variables.getThreadId();
        this.frameIndex = variables.getFrameIndex();
        Variable[] selection = variables.getSelection();
        StringBuilder buffer = new StringBuilder();
        Map<String, String> detailFormatters = variables.getDetailFormatters();
        for (Variable var : selection) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append(var.toStringEquivalent(thread, detailFormatters));
        }
        this.stringOfSelection = buffer.toString();
        int size = variables.getRootCount();
        this.locals = size == 0 ? NO_CHILDREN : new VariableNodeImpl[size];
        for (int i = 0; i < size; ++i) {
            AbstractVariableTreeModel.TreeNode node = variables.getRoot(i);
            this.locals[i] = new VariableNodeImpl(node);
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
        out.writeInt(this.frameIndex);
        out.writeUTF(this.stringOfSelection);
        out.writeInt(this.locals.length);
        for (int i = 0; i < this.locals.length; ++i) {
            this.locals[i].write(out);
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
        stream.println("    Stack frame index             : " + this.frameIndex);
        stream.println("    String of selection           : " + this.stringOfSelection);
        for (int i = 0; i < this.locals.length; ++i) {
            this.locals[i].print(stream, "        ");
        }
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public int getVariableCount() {
        return this.locals.length;
    }

    @Override
    public VariableTreePacket.VariableNode getVariable(int index) {
        return this.locals[index];
    }

    @Override
    public String getStringOfSelection() {
        return this.stringOfSelection;
    }

    public int hashCode() {
        return Arrays.hashCode(this.locals) ^ (int)(this.threadId >> 32 ^ this.threadId) ^ this.frameIndex ^ this.stringOfSelection.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVariableTreePacket other = (AbstractVariableTreePacket)obj;
        return this.threadId == other.threadId && this.frameIndex == other.frameIndex && Arrays.equals(this.locals, other.locals) && this.stringOfSelection.equals(other.stringOfSelection);
    }

    private static class VariableNodeImpl
    implements VariableTreePacket.VariableNode {
        private final VariableNodeImpl[] children;
        private final boolean mayHaveChildren;
        private final String name;
        private final String declaredTypeName;
        private final String concreteTypeName;
        private final String value;
        private final long objectId;
        private final boolean expanded;
        private final boolean selected;
        private final boolean synthetic;
        private final boolean isStatic;
        private final boolean isFinal;
        private final boolean isDirectlySettable;
        private final VisibilityType visibility;

        private VariableNodeImpl(DataInputStream in) throws IOException {
            this.name = in.readUTF();
            this.declaredTypeName = in.readUTF();
            this.concreteTypeName = in.readUTF();
            this.value = in.readUTF();
            this.objectId = in.readLong();
            this.expanded = in.readBoolean();
            this.selected = in.readBoolean();
            this.synthetic = in.readBoolean();
            this.isStatic = in.readBoolean();
            this.isFinal = in.readBoolean();
            this.isDirectlySettable = in.readBoolean();
            this.visibility = VisibilityType.read(in);
            int childCount = in.readInt();
            this.mayHaveChildren = childCount < 0;
            this.children = this.mayHaveChildren ? NO_CHILDREN : new VariableNodeImpl[childCount];
            for (int i = 0; i < childCount; ++i) {
                this.children[i] = new VariableNodeImpl(in);
            }
        }

        private VariableNodeImpl(AbstractVariableTreeModel.TreeNode node) {
            this.name = node.getValue().getName();
            this.declaredTypeName = node.getValue().getDeclaredTypeName();
            this.concreteTypeName = node.getValue().getConcreteTypeName();
            this.value = node.getValue().getValue();
            this.objectId = node.getValue().getObjectId();
            this.expanded = node.isExpanded();
            this.selected = node.isSelected();
            this.synthetic = node.getValue().isSynthetic();
            this.isStatic = node.getValue().isStatic();
            this.isFinal = node.getValue().isFinal();
            this.isDirectlySettable = node.getValue().isDirectlySettable();
            this.visibility = node.getValue().getVisibility();
            this.mayHaveChildren = node.mayHaveChildren();
            VariableNodeImpl[] variableNodeImplArray = this.children = this.mayHaveChildren ? NO_CHILDREN : new VariableNodeImpl[node.getChildCount()];
            if (!this.mayHaveChildren) {
                int childCount = node.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    this.children[i] = new VariableNodeImpl(node.getChild(i));
                }
            }
        }

        @Override
        public int getFieldCount() {
            assert (!this.mayHaveChildren || this.children.length == 0);
            return this.mayHaveChildren ? -1 : this.children.length;
        }

        @Override
        public VariableTreePacket.VariableNode getField(int index) {
            return this.children[index];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDeclaredTypeName() {
            return this.declaredTypeName;
        }

        @Override
        public String getConcreteTypeName() {
            return this.concreteTypeName;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public long getObjectId() {
            return this.objectId;
        }

        @Override
        public boolean isExpanded() {
            return this.expanded;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public boolean isSynthetic() {
            return this.synthetic;
        }

        @Override
        public boolean isStatic() {
            return this.isStatic;
        }

        @Override
        public boolean isFinal() {
            return this.isFinal;
        }

        @Override
        public boolean isDirectlySettable() {
            return this.isDirectlySettable;
        }

        @Override
        public VisibilityType getVisibility() {
            return this.visibility;
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeUTF(this.name);
            out.writeUTF(this.declaredTypeName);
            out.writeUTF(this.concreteTypeName);
            out.writeUTF(this.value);
            out.writeLong(this.objectId);
            out.writeBoolean(this.expanded);
            out.writeBoolean(this.selected);
            out.writeBoolean(this.synthetic);
            out.writeBoolean(this.isStatic);
            out.writeBoolean(this.isFinal);
            out.writeBoolean(this.isDirectlySettable);
            this.visibility.write(out);
            out.writeInt(this.mayHaveChildren ? -1 : this.children.length);
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].write(out);
            }
        }

        public void print(PrintStream stream, String ident) {
            stream.format("%s%s%s%s%s%s %-20s (%s id=%d,%3s children): %s (%s declared=%s actual=%s)", new Object[]{ident, this.expanded ? "E" : " ", this.selected ? "S" : " ", this.isStatic ? "s" : " ", this.isFinal ? "f" : " ", this.isDirectlySettable ? "d" : " ", this.name, this.synthetic ? "s" : " ", this.objectId, this.mayHaveChildren ? "?" : Integer.valueOf(this.children.length), this.value, this.visibility, this.declaredTypeName, this.concreteTypeName});
            stream.println();
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].print(stream, ident + "    ");
            }
        }

        public int hashCode() {
            return Arrays.hashCode(this.children) ^ (this.mayHaveChildren ? 1 : 0) ^ this.name.hashCode() ^ this.declaredTypeName.hashCode() ^ this.concreteTypeName.hashCode() ^ this.value.hashCode() ^ (int)(this.objectId >> 32 ^ this.objectId) ^ (this.expanded ? 2 : 0) ^ (this.selected ? 4 : 0) ^ (this.synthetic ? 8 : 0) ^ (this.isStatic ? 16 : 0) ^ (this.isFinal ? 32 : 0) ^ (this.isDirectlySettable ? 64 : 0) ^ this.visibility.hashCode();
        }

        @Override
        public boolean equalsIgnoreSelection(VariableTreePacket.VariableNode other) {
            return this.equals(other, false);
        }

        public boolean equals(Object obj, boolean includeSelection) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            VariableNodeImpl other = (VariableNodeImpl)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.declaredTypeName == null ? other.declaredTypeName != null : !this.declaredTypeName.equals(other.declaredTypeName)) {
                return false;
            }
            if (this.concreteTypeName == null ? other.concreteTypeName != null : !this.concreteTypeName.equals(other.concreteTypeName)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            if (includeSelection && this.selected != other.selected) {
                return false;
            }
            if (this.children.length != other.children.length) {
                return false;
            }
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i].equals(other.children[i], includeSelection)) continue;
                return false;
            }
            return this.mayHaveChildren == other.mayHaveChildren && this.objectId == other.objectId && this.expanded == other.expanded && this.synthetic == other.synthetic && this.isStatic == other.isStatic && this.isFinal == other.isFinal && this.isDirectlySettable == other.isDirectlySettable && this.visibility == other.visibility;
        }

        public boolean equals(Object obj) {
            return this.equals(obj, true);
        }
    }
}

