/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.controller.packets.ThreadListPacket;
import com.sap.jvm.debugging.presentation.BreakpointType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ActiveBreakpointImpl
implements ThreadListPacket.ActiveBreakpoint {
    private final String name;
    private final BreakpointType type;
    private final String text;

    public ActiveBreakpointImpl(DataInputStream in) throws IOException {
        this.name = in.readUTF();
        this.type = BreakpointType.read(in);
        this.text = in.readUTF();
    }

    public ActiveBreakpointImpl(Breakpoint breakpoint, String name, BreakpointType type) {
        this.name = name;
        this.type = type;
        this.text = breakpoint.toString();
        if (name == null || type == null || this.text == null) {
            throw new NullPointerException();
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        this.type.write(out);
        out.writeUTF(this.text);
    }

    public void print(PrintStream stream) {
        stream.println("            Breakpoint name       : " + this.name);
        stream.println("            Breakpoint type       : " + (Object)((Object)this.type));
        stream.println("            Breakpoint text       : " + this.text);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BreakpointType getType() {
        return this.type;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode() ^ this.text.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ActiveBreakpointImpl other = (ActiveBreakpointImpl)obj;
        return this.name.equals(other.name) && this.type == other.type && this.text.equals(other.text);
    }
}

