/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.controller.packets.ConditionalBreakpointFailurePacket;
import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.presentation.BreakpointType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ConditionalBreakpointFailurePacketImpl
implements ConditionalBreakpointFailurePacket {
    private final String name;
    private final BreakpointType type;
    private final String message;

    public static ConditionalBreakpointFailurePacketImpl read(DataInputStream in) throws IOException {
        return new ConditionalBreakpointFailurePacketImpl(in);
    }

    private ConditionalBreakpointFailurePacketImpl(DataInputStream in) throws IOException {
        this.name = in.readUTF();
        this.type = BreakpointType.read(in);
        this.message = in.readUTF();
    }

    public ConditionalBreakpointFailurePacketImpl(String name, BreakpointType type, String message) {
        this.name = name;
        this.type = type;
        this.message = message;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.CONDITIONAL_BREAKPOINT_FAILURE_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        this.type.write(out);
        out.writeUTF(this.message);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Breakpoint name               : " + this.name);
        stream.println("    Breakpoint type               : " + (Object)((Object)this.type));
        stream.println("    Message                       : " + this.message);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BreakpointType getBreakpointType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        return (this.name == null ? 9472 : this.name.hashCode()) ^ (this.type == null ? 37 : this.type.hashCode()) ^ (this.message == null ? 37 : this.message.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionalBreakpointFailurePacketImpl other = (ConditionalBreakpointFailurePacketImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.type == other.type;
    }
}

