/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.DetailFormattersListPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class DetailFormattersListPacketImpl
implements DetailFormattersListPacket {
    private final String[] classNames;
    private final String[] expressions;

    public static DetailFormattersListPacketImpl read(DataInputStream in) throws IOException {
        return new DetailFormattersListPacketImpl(in);
    }

    private DetailFormattersListPacketImpl(DataInputStream in) throws IOException {
        DataInputStream input = new DataInputStream(new GZIPInputStream(in));
        int size = input.readInt();
        this.classNames = new String[size];
        this.expressions = new String[size];
        for (int i = 0; i < size; ++i) {
            this.classNames[i] = input.readUTF();
            this.expressions[i] = input.readUTF();
        }
    }

    public DetailFormattersListPacketImpl(String[] classNames, String[] expressions) {
        if (classNames.length != expressions.length) {
            throw new IllegalArgumentException("Number of class names (" + classNames.length + ") and expressions (" + expressions.length + ") must be the same");
        }
        this.classNames = (String[])classNames.clone();
        this.expressions = (String[])expressions.clone();
    }

    public DetailFormattersListPacketImpl(Map<String, String> formatters) {
        this.classNames = new String[formatters.size()];
        this.expressions = new String[formatters.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : formatters.entrySet()) {
            this.classNames[i] = entry.getKey();
            this.expressions[i] = entry.getValue();
            ++i;
        }
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.DETAIL_FORMATTERS_LIST_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        assert (this.classNames.length == this.expressions.length);
        GZIPOutputStream zipOut = new GZIPOutputStream(out);
        DataOutputStream output = new DataOutputStream(zipOut);
        output.writeInt(this.classNames.length);
        for (int i = 0; i < this.classNames.length; ++i) {
            output.writeUTF(this.classNames[i]);
            output.writeUTF(this.expressions[i]);
        }
        zipOut.finish();
        output.flush();
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        for (int i = 0; i < this.classNames.length; ++i) {
            stream.println("    " + i + ". Detail Formatter            : " + this.classNames[i]);
            stream.println("    Expression                    : " + this.expressions[i]);
        }
    }

    @Override
    public int getNumberOfFormatters() {
        assert (this.classNames.length == this.expressions.length);
        return this.classNames.length;
    }

    @Override
    public String getClassName(int index) {
        return this.classNames[index];
    }

    @Override
    public String getExpression(int index) {
        return this.expressions[index];
    }

    public int hashCode() {
        return Arrays.hashCode(this.classNames) ^ Arrays.hashCode(this.expressions);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DetailFormattersListPacketImpl other = (DetailFormattersListPacketImpl)obj;
        return Arrays.equals(this.classNames, other.classNames) && Arrays.equals(this.expressions, other.expressions);
    }
}

