/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.DisassembledClassPacket;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class DisassembledClassPacketImpl
implements DisassembledClassPacket {
    private final String className;
    private final long classObjectId;
    private final String[] disassembly;
    private final Map<String, Integer> disassemblyMethod2Line = new HashMap<String, Integer>();
    private final String[] decompiledCode;
    private final Map<String, Integer> decompiledCodeMethod2Line = new HashMap<String, Integer>();

    public static DisassembledClassPacketImpl read(DataInputStream in) throws IOException {
        return new DisassembledClassPacketImpl(in);
    }

    private DisassembledClassPacketImpl(DataInputStream in) throws IOException {
        int line;
        String method;
        int i;
        DataInputStream input = new DataInputStream(new GZIPInputStream(in));
        this.className = input.readUTF();
        this.classObjectId = input.readLong();
        int disassemblySize = input.readInt();
        this.disassembly = new String[disassemblySize];
        int disassemblyMapSize = input.readInt();
        int decompiledSize = input.readInt();
        this.decompiledCode = new String[decompiledSize];
        int decompiledMapSize = input.readInt();
        for (i = 0; i < disassemblySize; ++i) {
            this.disassembly[i] = input.readUTF();
        }
        for (i = 0; i < decompiledSize; ++i) {
            this.decompiledCode[i] = input.readUTF();
        }
        for (i = 0; i < disassemblyMapSize; ++i) {
            method = input.readUTF();
            line = input.readInt();
            this.disassemblyMethod2Line.put(method, line);
        }
        for (i = 0; i < decompiledMapSize; ++i) {
            method = input.readUTF();
            line = input.readInt();
            this.decompiledCodeMethod2Line.put(method, line);
        }
    }

    public DisassembledClassPacketImpl(String className, long classObjectId, String[] disassembly, Map<String, Integer> disassemblyMethod2Line, String[] decompiledCode, Map<String, Integer> decompiledCodeMethod2Line) {
        this.className = className;
        this.classObjectId = classObjectId;
        this.disassembly = (String[])disassembly.clone();
        this.disassemblyMethod2Line.putAll(disassemblyMethod2Line);
        this.decompiledCode = (String[])decompiledCode.clone();
        this.decompiledCodeMethod2Line.putAll(decompiledCodeMethod2Line);
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.DISASSEMBLED_CLASS_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        int i;
        GZIPOutputStream zipOut = new GZIPOutputStream(out);
        DataOutputStream output = new DataOutputStream(zipOut);
        output.writeUTF(this.className);
        output.writeLong(this.classObjectId);
        output.writeInt(this.disassembly.length);
        output.writeInt(this.disassemblyMethod2Line.size());
        output.writeInt(this.decompiledCode.length);
        output.writeInt(this.decompiledCodeMethod2Line.size());
        for (i = 0; i < this.disassembly.length; ++i) {
            output.writeUTF(this.disassembly[i]);
        }
        for (i = 0; i < this.decompiledCode.length; ++i) {
            output.writeUTF(this.decompiledCode[i]);
        }
        for (Map.Entry<String, Integer> entry : this.disassemblyMethod2Line.entrySet()) {
            output.writeUTF(entry.getKey());
            output.writeInt(entry.getValue());
        }
        for (Map.Entry<String, Integer> entry : this.decompiledCodeMethod2Line.entrySet()) {
            output.writeUTF(entry.getKey());
            output.writeInt(entry.getValue());
        }
        zipOut.finish();
        output.flush();
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Class name                    : " + this.className);
        stream.println("    Class object identifier       : " + this.classObjectId);
        stream.println("    Disassembly:");
        for (int i = 0; i < this.disassembly.length; ++i) {
            stream.println("    " + (i + 1) + " : " + this.disassembly[i]);
        }
        stream.println("    Disassembly mappings:");
        for (Map.Entry<String, Integer> entry : this.disassemblyMethod2Line.entrySet()) {
            stream.println("        " + entry.getKey() + " => line " + entry.getValue());
        }
        stream.println("    Decompiled code:");
        for (int i = 0; i < this.decompiledCode.length; ++i) {
            stream.println("    " + (i + 1) + " : " + this.decompiledCode[i]);
        }
        stream.println("    Decompiled code mappings:");
        for (Map.Entry<String, Integer> entry : this.decompiledCodeMethod2Line.entrySet()) {
            stream.println("        " + entry.getKey() + " => line " + entry.getValue());
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public long getClassObjectId() {
        return this.classObjectId;
    }

    @Override
    public String[] getDisassembly() {
        return (String[])this.disassembly.clone();
    }

    @Override
    public int getLineOfDisassemblyBci(String method, int bci) {
        Integer result = this.disassemblyMethod2Line.get(method + ":" + bci);
        return result == null ? -1 : result;
    }

    @Override
    public DisassembledClassPacket.MethodByteCodeIndex getDisassemblyMethodByteCodeIndexOfLine(int line) {
        if (line < 0 || line >= this.disassembly.length) {
            return null;
        }
        for (Map.Entry<String, Integer> entry : this.disassemblyMethod2Line.entrySet()) {
            Integer value = entry.getValue();
            if (value == null || value != line) continue;
            return new MethodByteCodeIndexImpl(entry.getKey());
        }
        return null;
    }

    @Override
    public String[] getDecompiledCode() {
        return (String[])this.decompiledCode.clone();
    }

    @Override
    public int getLineOfDecompiledCode(String method, int bci) {
        Integer result = this.decompiledCodeMethod2Line.get(method + ":" + bci);
        return result == null ? -1 : result;
    }

    @Override
    public DisassembledClassPacket.MethodByteCodeIndex getDecompiledCodeMethodByteCodeIndexOfLine(int line) {
        if (line < 0 || line >= this.decompiledCode.length) {
            return null;
        }
        for (Map.Entry<String, Integer> entry : this.decompiledCodeMethod2Line.entrySet()) {
            Integer value = entry.getValue();
            if (value == null || value != line) continue;
            return new MethodByteCodeIndexImpl(entry.getKey());
        }
        return null;
    }

    public int hashCode() {
        int result = 23;
        result ^= this.className.hashCode();
        result ^= (int)(this.classObjectId >> 32 ^ this.classObjectId);
        result ^= Arrays.hashCode(this.disassembly);
        result ^= this.disassemblyMethod2Line.hashCode();
        result ^= Arrays.hashCode(this.decompiledCode);
        return result ^= this.decompiledCodeMethod2Line.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DisassembledClassPacketImpl other = (DisassembledClassPacketImpl)obj;
        return this.className.equals(other.className) && this.classObjectId == other.classObjectId && Arrays.equals(this.disassembly, other.disassembly) && this.disassemblyMethod2Line.equals(other.disassemblyMethod2Line) && Arrays.equals(this.decompiledCode, other.decompiledCode) && this.decompiledCodeMethod2Line.equals(this.decompiledCodeMethod2Line);
    }

    private static class MethodByteCodeIndexImpl
    implements DisassembledClassPacket.MethodByteCodeIndex {
        private final String method;
        private final int bci;

        private MethodByteCodeIndexImpl(String name) {
            int colon = name.lastIndexOf(58);
            this.method = name.substring(0, colon);
            this.bci = Integer.parseInt(name.substring(colon + 1));
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        @Override
        public int getByteCodeIndex() {
            return this.bci;
        }
    }
}

