/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.controller.packets.ThreadListPacket;
import com.sap.jvm.debugging.types.FrameHandle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class FrameImpl
implements ThreadListPacket.Frame {
    private final String fullMethodName;
    private final String returnType;
    private final boolean methodNative;
    private final int lineNr;
    private final int bci;
    private final boolean selected;
    private final String sourceFile;
    private final String sourcePrefix;

    public FrameImpl(DataInputStream in) throws IOException {
        this.fullMethodName = in.readUTF();
        this.returnType = in.readUTF();
        this.methodNative = in.readBoolean();
        this.lineNr = in.readInt();
        this.bci = in.readInt();
        this.selected = in.readBoolean();
        this.sourceFile = in.readUTF();
        this.sourcePrefix = in.readUTF();
    }

    public FrameImpl(FrameHandle frame, boolean selected) {
        String name = frame.getMethodHandle().toString();
        int lastBracket = name.lastIndexOf(41);
        String returnTypeValue = "";
        if (lastBracket >= 0) {
            returnTypeValue = name.substring(lastBracket + 1);
            name = name.substring(0, lastBracket + 1);
        }
        this.fullMethodName = name;
        this.returnType = returnTypeValue;
        this.methodNative = frame.getMethodHandle().isNative();
        this.lineNr = frame.getLineNr();
        this.bci = frame.getBci();
        this.selected = selected;
        this.sourceFile = frame.getSourceName();
        this.sourcePrefix = frame.getSourcePrefix();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.fullMethodName);
        out.writeUTF(this.returnType);
        out.writeBoolean(this.methodNative);
        out.writeInt(this.lineNr);
        out.writeInt(this.bci);
        out.writeBoolean(this.selected);
        out.writeUTF(this.sourceFile);
        out.writeUTF(this.sourcePrefix);
    }

    public void print(PrintStream stream) {
        stream.println("            Method name           : " + this.fullMethodName);
        if (this.returnType.length() > 0) {
            stream.println("            Return type name      : " + this.returnType);
        }
        stream.println("            Native method         : " + (this.methodNative ? "yes" : "no"));
        stream.println("            Line number           : " + this.lineNr);
        stream.println("            Byte code index       : " + this.bci);
        stream.println("            Selected              : " + (this.selected ? "yes" : "no"));
        stream.println("            Source file           : " + this.sourcePrefix + (this.sourcePrefix.length() > 0 ? "/" : "") + this.sourceFile);
    }

    @Override
    public String getMethodName() {
        return this.fullMethodName;
    }

    @Override
    public String getMethodNameWithReturnType() {
        return this.fullMethodName + ":" + this.returnType;
    }

    @Override
    public boolean isMethodNative() {
        return this.methodNative;
    }

    @Override
    public int getLineNr() {
        return this.lineNr;
    }

    @Override
    public int getByteCodeIndex() {
        return this.bci;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public String getSourceName() {
        return this.sourceFile;
    }

    @Override
    public String getSourcePrefix() {
        return this.sourcePrefix;
    }

    public int hashCode() {
        int prime = 23;
        int result = 1;
        result = 23 * result + this.lineNr;
        result = 23 * result + this.bci;
        result = 23 * result + (this.fullMethodName == null ? 0 : this.fullMethodName.hashCode());
        result = 23 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        result = 23 * result + (this.methodNative ? 1231 : 1237);
        result = 23 * result + (this.selected ? 1231 : 1237);
        result = 23 * result + (this.sourceFile == null ? 0 : this.sourceFile.hashCode());
        result = 23 * result + (this.sourcePrefix == null ? 0 : this.sourcePrefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FrameImpl other = (FrameImpl)obj;
        if (this.fullMethodName == null ? other.fullMethodName != null : !this.fullMethodName.equals(other.fullMethodName)) {
            return false;
        }
        if (this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType)) {
            return false;
        }
        if (this.sourceFile == null ? other.sourceFile != null : !this.sourceFile.equals(other.sourceFile)) {
            return false;
        }
        if (this.sourcePrefix == null ? other.sourcePrefix != null : !this.sourcePrefix.equals(other.sourcePrefix)) {
            return false;
        }
        return this.methodNative == other.methodNative && this.lineNr == other.lineNr && this.bci == other.bci && this.selected == other.selected;
    }

    public String toString() {
        return this.fullMethodName + " line: " + (this.lineNr == -1 ? "not available" : Integer.valueOf(this.lineNr)) + (this.methodNative ? " [native method]" : "");
    }
}

