/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.controller.impl.packets.AbstractVariableTreePacket;
import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.HoverExpressionTreePacket;
import com.sap.jvm.debugging.presentation.ExpressionVariableTreeModel;
import com.sap.jvm.debugging.types.ThreadHandle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class HoverExpressionTreePacketImpl
extends AbstractVariableTreePacket
implements HoverExpressionTreePacket {
    private final boolean[] evaluationFailures = new boolean[this.getVariableCount()];

    public static HoverExpressionTreePacketImpl read(DataInputStream in) throws IOException {
        return new HoverExpressionTreePacketImpl(new DataInputStream(new GZIPInputStream(in)));
    }

    private HoverExpressionTreePacketImpl(DataInputStream in) throws IOException {
        super(in);
        for (int i = 0; i < this.evaluationFailures.length; ++i) {
            this.evaluationFailures[i] = in.readBoolean();
        }
    }

    public HoverExpressionTreePacketImpl(ExpressionVariableTreeModel variables, ThreadHandle thread) {
        super(variables, thread);
        for (int i = 0; i < this.evaluationFailures.length; ++i) {
            this.evaluationFailures[i] = variables.hasEvaluationFailed(i);
        }
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.HOVER_EXPRESSION_TREE_TAG;
    }

    @Override
    public boolean hasEvaluationFailed(int index) {
        return this.evaluationFailures[index];
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        GZIPOutputStream zipOut = new GZIPOutputStream(out);
        DataOutputStream output = new DataOutputStream(zipOut);
        super.write(output);
        for (int i = 0; i < this.evaluationFailures.length; ++i) {
            output.writeBoolean(this.evaluationFailures[i]);
        }
        zipOut.finish();
        output.flush();
    }

    @Override
    public void print(PrintStream stream) {
        super.print(stream);
        for (int i = 0; i < this.evaluationFailures.length; ++i) {
            if (!this.evaluationFailures[i]) continue;
            stream.println("    Evaluation of expression " + i + " failed");
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.evaluationFailures);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Arrays.equals(this.evaluationFailures, ((HoverExpressionTreePacketImpl)obj).evaluationFailures);
    }
}

