/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.controller.impl.packets.AbstractVariableTreePacket;
import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableTreePacket;
import com.sap.jvm.debugging.presentation.LocalVariableTreeModel;
import com.sap.jvm.debugging.types.ThreadHandle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class LocalVariableTreePacketImpl
extends AbstractVariableTreePacket
implements LocalVariableTreePacket {
    public static LocalVariableTreePacketImpl read(DataInputStream in) throws IOException {
        return new LocalVariableTreePacketImpl(new DataInputStream(new GZIPInputStream(in)));
    }

    private LocalVariableTreePacketImpl(DataInputStream in) throws IOException {
        super(in);
    }

    public LocalVariableTreePacketImpl(LocalVariableTreeModel variables, ThreadHandle thread) {
        super(variables, thread);
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.LOCAL_VARIABLE_TREE_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        GZIPOutputStream zipOut = new GZIPOutputStream(out);
        DataOutputStream output = new DataOutputStream(zipOut);
        super.write(output);
        zipOut.finish();
        output.flush();
    }
}

