/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.LogicalStructuresListPacket;
import com.sap.jvm.debugging.presentation.LogicalStructureDefinition;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class LogicalStructuresListPacketImpl
implements LogicalStructuresListPacket {
    private final LogicalStructureDefinition[] definitions;

    public static LogicalStructuresListPacketImpl read(DataInputStream in) throws IOException {
        return new LogicalStructuresListPacketImpl(in);
    }

    private LogicalStructuresListPacketImpl(DataInputStream in) throws IOException {
        DataInputStream input = new DataInputStream(new GZIPInputStream(in));
        int size = input.readInt();
        this.definitions = new LogicalStructureDefinition[size];
        for (int i = 0; i < size; ++i) {
            this.definitions[i] = LogicalStructureDefinition.read(input);
        }
    }

    public LogicalStructuresListPacketImpl(LogicalStructureDefinition[] definitions) {
        this.definitions = (LogicalStructureDefinition[])definitions.clone();
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.LOGICAL_STRUCTURES_LIST_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        GZIPOutputStream zipOut = new GZIPOutputStream(out);
        DataOutputStream output = new DataOutputStream(zipOut);
        output.writeInt(this.definitions.length);
        for (int i = 0; i < this.definitions.length; ++i) {
            this.definitions[i].write(output);
        }
        zipOut.finish();
        output.flush();
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        for (int i = 0; i < this.definitions.length; ++i) {
            stream.println("    " + (i + 1) + ". Logical Structure Definition");
            this.definitions[i].print(stream);
        }
    }

    @Override
    public int getNumberOfLogicalStructures() {
        return this.definitions.length;
    }

    @Override
    public LogicalStructureDefinition getStructure(int index) {
        return this.definitions[index];
    }

    public int hashCode() {
        return Arrays.hashCode(this.definitions);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LogicalStructuresListPacketImpl other = (LogicalStructuresListPacketImpl)obj;
        return Arrays.equals(this.definitions, other.definitions);
    }
}

