/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.controller.packets.ThreadListPacket;
import com.sap.jvm.debugging.types.ObjectHandle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ObjectMonitorImpl
implements ThreadListPacket.ObjectMonitor {
    private final String text;

    public ObjectMonitorImpl(DataInputStream in) throws IOException {
        this.text = in.readUTF();
    }

    public ObjectMonitorImpl(ObjectHandle monitor2) {
        this.text = monitor2.getClassHandle().getDisplayName() + " (id=" + monitor2.getId() + ")";
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.text);
    }

    @Override
    public String getText() {
        return this.text;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectMonitorImpl other = (ObjectMonitorImpl)obj;
        return this.text.equals(other.text);
    }
}

