/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.DebuggerFactory;
import com.sap.jvm.debugging.ThreadChanges;
import com.sap.jvm.debugging.ThreadStateListener;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.breakpoints.BreakpointLocation;
import com.sap.jvm.debugging.controller.DebuggingController;
import com.sap.jvm.debugging.controller.impl.packets.AbstractVariableTreePacket;
import com.sap.jvm.debugging.controller.impl.packets.ConditionalBreakpointFailurePacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.DetailFormattersListPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.DisassembledClassPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.ExpressionVariableTreePacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.HotCodeReplacementErrorPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.HoverExpressionTreePacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.LocalVariableTreePacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.LogicalStructuresListPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.ThreadListDeltaPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.ThreadListPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.VariableAssignmentFailurePacketImpl;
import com.sap.jvm.debugging.controller.packets.ConditionalBreakpointFailurePacket;
import com.sap.jvm.debugging.controller.packets.ConnectPacket;
import com.sap.jvm.debugging.controller.packets.ConnectToPidPacket;
import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.debugging.controller.packets.DisassembledClassPacket;
import com.sap.jvm.debugging.controller.packets.ExitVmPacket;
import com.sap.jvm.debugging.controller.packets.HotCodeReplacementErrorPacket;
import com.sap.jvm.debugging.controller.packets.HotCodeReplacementPacket;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.RefreshPacket;
import com.sap.jvm.debugging.controller.packets.RequestDisassemblyByNamePacket;
import com.sap.jvm.debugging.controller.packets.RequestDisassemblyByThreadPacket;
import com.sap.jvm.debugging.controller.packets.ResumeAllThreadsPacket;
import com.sap.jvm.debugging.controller.packets.ResumeThreadPacket;
import com.sap.jvm.debugging.controller.packets.ShutdownPacket;
import com.sap.jvm.debugging.controller.packets.StartDebuggingPacket;
import com.sap.jvm.debugging.controller.packets.StepThreadPacket;
import com.sap.jvm.debugging.controller.packets.SuspendAllThreadsPacket;
import com.sap.jvm.debugging.controller.packets.SuspendThreadPacket;
import com.sap.jvm.debugging.controller.packets.ThreadListDeltaPacket;
import com.sap.jvm.debugging.controller.packets.ThreadListFilterPacket;
import com.sap.jvm.debugging.controller.packets.ThreadListPacket;
import com.sap.jvm.debugging.controller.packets.ThreadListSelectPacket;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointListPacket;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointListPacketImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.SkipAllBreakpointsPacket;
import com.sap.jvm.debugging.controller.packets.variables.AddDetailFormattersPacket;
import com.sap.jvm.debugging.controller.packets.variables.AddExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.AddHoverExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.AddLogicalStructuresPacket;
import com.sap.jvm.debugging.controller.packets.variables.ChangeExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.DetailFormattersListPacket;
import com.sap.jvm.debugging.controller.packets.variables.EvalExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableExpansionPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableFilterPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSelectPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSetExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSetPacket;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableTreePacket;
import com.sap.jvm.debugging.controller.packets.variables.HoverExpressionExpansionPacket;
import com.sap.jvm.debugging.controller.packets.variables.HoverExpressionSelectPacket;
import com.sap.jvm.debugging.controller.packets.variables.HoverExpressionTreePacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableExpansionPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableFilterPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSelectPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSetExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSetPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableTreePacket;
import com.sap.jvm.debugging.controller.packets.variables.LogicalStructuresListPacket;
import com.sap.jvm.debugging.controller.packets.variables.RemoveDetailFormattersPacket;
import com.sap.jvm.debugging.controller.packets.variables.RemoveExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.RemoveHoverExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.RemoveLogicalStructurePacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableAssignmentFailurePacket;
import com.sap.jvm.debugging.decompiler.AnnotatedPrintStream;
import com.sap.jvm.debugging.exceptions.AssignmentException;
import com.sap.jvm.debugging.exceptions.EvaluationException;
import com.sap.jvm.debugging.presentation.AbstractVariableTreeModel;
import com.sap.jvm.debugging.presentation.BreakpointListModel;
import com.sap.jvm.debugging.presentation.BreakpointNameWithType;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import com.sap.jvm.debugging.presentation.ExpressionVariableTreeModel;
import com.sap.jvm.debugging.presentation.LocalVariableTreeModel;
import com.sap.jvm.debugging.presentation.ThreadListModel;
import com.sap.jvm.debugging.presentation.VariableTreeNode;
import com.sap.jvm.debugging.types.ClassHandle;
import com.sap.jvm.debugging.types.FrameHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.tools.example.debug.expr.ParseException;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.concurrent.QueueHelper;
import com.sap.jvm.util.misc.SocketAdapter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public final class PacketHandlerImpl
implements PacketHandler {
    private DebuggingController controller = null;
    private Debugger debugger = null;
    private final ThreadListModel.ThreadSelectionChangeListener selectionListener = new ThreadSelectionChangeListenerImpl();
    private final ConditionFailureListenerImpl conditionListener = new ConditionFailureListenerImpl();
    private final LinkedList<DebuggingPacket> delayedPackets = new LinkedList();
    private final Tracer tracer;
    private final Tracer localTracer;
    private final Tracer threadTracer;
    private final String sessionSuffix;
    private boolean defaultWaitForStart;

    public PacketHandlerImpl(Object context, String sessionSuffix, boolean defaultWaitForStart) {
        this.sessionSuffix = sessionSuffix;
        this.defaultWaitForStart = defaultWaitForStart;
        this.tracer = Trace.get((String)"com.sap.jvm.debugging.controller.packets", (Object)context);
        this.localTracer = Trace.get((String)"com.sap.jvm.debugging.controller.packets.locals", (Object)context);
        this.threadTracer = Trace.get((String)"com.sap.jvm.debugging.controller.packets.threads", (Object)context);
    }

    @Override
    public void close() {
        if (this.debugger != null) {
            this.debugger.disconnect();
        }
    }

    @Override
    public void handle(ThreadListPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ThreadListDeltaPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ConnectPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.connect(packet.getHostname(), packet.getPort(), this.defaultWaitForStart);
    }

    @Override
    public void handle(ConnectToPidPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.connect(packet.getPid(), this.defaultWaitForStart);
    }

    @Override
    public void handle(ExitVmPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.debugger.exitVm(packet.getExitCode());
    }

    @Override
    public void handle(StartDebuggingPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.debugger.start();
    }

    @Override
    public void handle(SuspendAllThreadsPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.debugger.suspendAll();
    }

    @Override
    public void handle(ResumeAllThreadsPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.debugger.resumeAll();
    }

    @Override
    public void handle(SuspendThreadPacket packet) {
        assert (this.controller.isInTaskExecution());
        ThreadHandle thread = this.controller.getThreads().get(packet.getThreadId());
        if (thread != null) {
            thread.suspend();
        }
    }

    @Override
    public void handle(ResumeThreadPacket packet) {
        assert (this.controller.isInTaskExecution());
        ThreadHandle thread = this.controller.getThreads().get(packet.getThreadId());
        if (thread != null) {
            thread.resume();
        }
    }

    @Override
    public void handle(ThreadListSelectPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.controller.getThreads().select(packet.getThreadId(), packet.getFrameIndex());
        this.sendThreadList(false);
    }

    @Override
    public void handle(LocalVariableTreePacket packet) {
        assert (false);
    }

    @Override
    public void handle(ExpressionVariableTreePacket packet) {
        assert (false);
    }

    @Override
    public void handle(LocalVariableExpansionPacket packet) {
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getLocals().getThreadId();
            frameIndex = this.controller.getLocals().getFrameIndex();
        }
        if (packet.isExpanded()) {
            this.controller.getLocals().expand(threadId, frameIndex, packet.getPath());
        } else {
            this.controller.getLocals().collapse(threadId, frameIndex, packet.getPath());
        }
        LocalVariableTreePacketImpl response = new LocalVariableTreePacketImpl(this.controller.getLocals(), this.controller.getThreads().get(this.controller.getLocals().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), response);
    }

    @Override
    public void handle(ExpressionVariableExpansionPacket packet) {
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getExpressions().getThreadId();
            frameIndex = this.controller.getExpressions().getFrameIndex();
        }
        if (packet.isExpanded()) {
            this.controller.getExpressions().expand(threadId, frameIndex, packet.getPath());
        } else {
            this.controller.getExpressions().collapse(threadId, frameIndex, packet.getPath());
        }
        ExpressionVariableTreePacketImpl response = new ExpressionVariableTreePacketImpl(this.controller.getExpressions(), this.controller.getThreads().get(this.controller.getExpressions().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), response);
    }

    @Override
    public void handle(LocalVariableFilterPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.localTracer.debug("Local-Variable-Filter: show statics=%s, show constants=%s, show return values=%s", new Object[]{Boolean.toString(packet.showStatics()), Boolean.toString(packet.showConstants()), Boolean.toString(packet.includeReturnValuesAsVariables())});
        this.debugger.setReturnValuesAsVariables(packet.includeReturnValuesAsVariables(), packet.ignoreReturnValuesStoredInLocalVars(), packet.ignoreReturnValuesUsedAsParameter(), packet.ignoreReturnValuesUsedAsReceiver(), packet.getRegexpsForMethodsToIgnore());
        this.controller.getLocals().filter(packet.showStatics(), packet.showConstants(), packet.showSyntheticVariables(), packet.showLogicalStructure(), packet.includeReturnValuesAsVariables());
        LocalVariableTreePacketImpl response = new LocalVariableTreePacketImpl(this.controller.getLocals(), this.controller.getThreads().get(this.controller.getLocals().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), response);
        this.localTracer.debug("Local-Variable-Filter: Put new local variable tree packet into write queue.");
    }

    @Override
    public void handle(ExpressionVariableFilterPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.localTracer.debug("Expression-Variable-Filter: show statics=%s, show constants=%s", new Object[]{Boolean.toString(packet.showStatics()), Boolean.toString(packet.showConstants())});
        this.controller.getExpressions().filter(packet.showStatics(), packet.showConstants(), packet.showSyntheticVariables(), packet.showLogicalStructure(), false);
        ExpressionVariableTreePacketImpl response = new ExpressionVariableTreePacketImpl(this.controller.getExpressions(), this.controller.getThreads().get(this.controller.getExpressions().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), response);
        this.localTracer.debug("Expression-Variable-Filter: Put new expression variable tree packet into write queue.");
    }

    @Override
    public void handle(StepThreadPacket packet) {
        assert (this.controller.isInTaskExecution());
        ThreadHandle thread = this.controller.getThreads().get(packet.getThreadId());
        if (thread != null && thread.isSuspended()) {
            switch (packet.getPolicy()) {
                case STEP_MIN_INTO: {
                    thread.stepMinInto();
                    break;
                }
                case STEP_INTO: {
                    thread.stepInto();
                    break;
                }
                case STEP_OVER: {
                    thread.stepOver();
                    break;
                }
                case STEP_OUT: {
                    thread.stepOut();
                    break;
                }
                case STEP_MIN_OVER: {
                    thread.stepMinOver();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown step policy: " + (Object)((Object)packet.getPolicy()));
                }
            }
        }
    }

    @Override
    public void handle(LocalVariableSelectPacket packet) {
        int i;
        assert (this.controller.isInTaskExecution());
        if (packet.isSelected()) {
            this.controller.getLocals().clearSelection(packet.getThreadId(), packet.getFrameIndex());
            for (i = 0; i < packet.getPathCount(); ++i) {
                this.controller.getLocals().select(packet.getThreadId(), packet.getFrameIndex(), packet.getPath(i));
            }
        } else {
            for (i = 0; i < packet.getPathCount(); ++i) {
                this.controller.getLocals().deselect(packet.getThreadId(), packet.getFrameIndex(), packet.getPath(i));
            }
        }
        LocalVariableTreePacketImpl response = new LocalVariableTreePacketImpl(this.controller.getLocals(), this.controller.getThreads().get(this.controller.getLocals().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), response);
    }

    @Override
    public void handle(ExpressionVariableSelectPacket packet) {
        int i;
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getExpressions().getThreadId();
            frameIndex = this.controller.getExpressions().getFrameIndex();
        }
        if (packet.isSelected()) {
            this.controller.getExpressions().clearSelection(threadId, frameIndex);
            for (i = 0; i < packet.getPathCount(); ++i) {
                this.controller.getExpressions().select(threadId, frameIndex, packet.getPath(i));
            }
        } else {
            for (i = 0; i < packet.getPathCount(); ++i) {
                this.controller.getExpressions().deselect(threadId, frameIndex, packet.getPath(i));
            }
        }
        ExpressionVariableTreePacketImpl response = new ExpressionVariableTreePacketImpl(this.controller.getExpressions(), this.controller.getThreads().get(this.controller.getExpressions().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), response);
    }

    @Override
    public void handle(LocalVariableSetPacket packet) {
        int index;
        assert (this.controller.isInTaskExecution());
        ThreadHandle thread = this.controller.getThreads().get(packet.getThreadId());
        this.controller.getLocals().setValue(thread, packet.getFrameIndex(), packet.getPath(), packet.getValue());
        if (thread != null && (index = Math.max(packet.getFrameIndex(), 0)) < thread.getFrames().length) {
            this.controller.getExpressions().update(packet.getThreadId(), packet.getFrameIndex(), thread.getFrames()[index]);
            this.controller.getLocals().update(packet.getThreadId(), packet.getFrameIndex(), thread.getFrames()[index]);
        }
        this.sendLocalsAndExpressions("Local-Variable-Setting");
    }

    @Override
    public void handle(ExpressionVariableSetPacket packet) {
        int index;
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getExpressions().getThreadId();
            frameIndex = this.controller.getExpressions().getFrameIndex();
        }
        ThreadHandle thread = this.controller.getThreads().get(threadId);
        this.controller.getExpressions().setValue(thread, frameIndex, packet.getPath(), packet.getValue());
        if (thread != null && (index = Math.max(packet.getFrameIndex(), 0)) < thread.getFrames().length) {
            this.controller.getLocals().update(threadId, frameIndex, thread.getFrames()[index]);
        }
        this.sendLocalsAndExpressions("Expression-Variable-Setting");
    }

    @Override
    public void handle(AddExpressionPacket packet) {
        boolean result;
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getExpressions().getThreadId();
            frameIndex = this.controller.getExpressions().getFrameIndex();
        }
        if (!(result = this.controller.getExpressions().addExpression(this.controller.getThreads().get(threadId), frameIndex, packet.getExpression()))) {
            this.delayedPackets.add(packet);
        } else {
            this.sendLocalsAndExpressions("Add-Expression-Variable");
        }
    }

    @Override
    public void handle(ChangeExpressionPacket packet) {
        boolean result;
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getExpressions().getThreadId();
            frameIndex = this.controller.getExpressions().getFrameIndex();
        }
        if (!(result = this.controller.getExpressions().changeExpression(this.controller.getThreads().get(threadId), frameIndex, packet.getNewExpression(), packet.getExpressionIndex()))) {
            this.delayedPackets.add(packet);
        } else {
            this.sendLocalsAndExpressions("Change-Expression-Variable");
        }
    }

    @Override
    public void handle(RemoveExpressionPacket packet) {
        boolean result;
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getExpressions().getThreadId();
            frameIndex = this.controller.getExpressions().getFrameIndex();
        }
        if (!(result = this.controller.getExpressions().removeExpression(this.controller.getThreads().get(threadId), frameIndex, packet.getExpression(), packet.getExpressionIndex()))) {
            this.delayedPackets.add(packet);
        } else {
            this.sendLocalsAndExpressions("Remove-Expression-Variable");
        }
    }

    @Override
    public void handle(EvalExpressionPacket packet) {
        assert (this.controller.isInTaskExecution());
        long threadId = this.controller.getExpressions().getThreadId();
        int frameIndex = this.controller.getExpressions().getFrameIndex();
        this.controller.getExpressions().updateExpression(this.controller.getThreads().get(threadId), frameIndex, packet.getExpressionIndices());
        this.sendLocalsAndExpressions("Update-Expression-Variable");
    }

    @Override
    public void handle(LocalVariableSetExpressionPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.setExpression(this.controller.getLocals(), packet.getThreadId(), packet.getFrameIndex(), packet.getPath(), packet.getExpression(), "Local-Variable-Set-Expression");
    }

    @Override
    public void handle(ExpressionVariableSetExpressionPacket packet) {
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getExpressions().getThreadId();
            frameIndex = this.controller.getExpressions().getFrameIndex();
        }
        this.setExpression(this.controller.getExpressions(), threadId, frameIndex, packet.getPath(), packet.getExpression(), "Expression-Variable-Set-Expression");
    }

    @Override
    public void handle(HoverExpressionTreePacket packet) {
        assert (false);
    }

    @Override
    public void handle(AddHoverExpressionPacket packet) {
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getHoverExpressions().getThreadId();
            frameIndex = this.controller.getHoverExpressions().getFrameIndex();
        }
        this.controller.getHoverExpressions().addExpression(this.controller.getThreads().get(threadId), frameIndex, packet.getExpression());
        this.sendLocalsAndExpressions("Add-Hover-Expression");
    }

    @Override
    public void handle(RemoveHoverExpressionPacket packet) {
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getHoverExpressions().getThreadId();
            frameIndex = this.controller.getHoverExpressions().getFrameIndex();
        }
        this.controller.getHoverExpressions().removeExpression(this.controller.getThreads().get(threadId), frameIndex, packet.getExpression(), packet.getExpressionIndex());
        this.sendLocalsAndExpressions("Remove-Hover-Expression");
    }

    @Override
    public void handle(HoverExpressionExpansionPacket packet) {
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getHoverExpressions().getThreadId();
            frameIndex = this.controller.getHoverExpressions().getFrameIndex();
        }
        if (packet.isExpanded()) {
            this.controller.getHoverExpressions().expand(threadId, frameIndex, packet.getPath());
        } else {
            this.controller.getHoverExpressions().collapse(threadId, frameIndex, packet.getPath());
        }
        HoverExpressionTreePacketImpl response = new HoverExpressionTreePacketImpl(this.controller.getHoverExpressions(), this.controller.getThreads().get(this.controller.getHoverExpressions().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), response);
    }

    @Override
    public void handle(HoverExpressionSelectPacket packet) {
        int i;
        assert (this.controller.isInTaskExecution());
        long threadId = packet.getThreadId();
        int frameIndex = packet.getFrameIndex();
        if (threadId == 0L && frameIndex == -1) {
            threadId = this.controller.getHoverExpressions().getThreadId();
            frameIndex = this.controller.getHoverExpressions().getFrameIndex();
        }
        if (packet.isSelected()) {
            this.controller.getHoverExpressions().clearSelection(threadId, frameIndex);
            for (i = 0; i < packet.getPathCount(); ++i) {
                this.controller.getHoverExpressions().select(threadId, frameIndex, packet.getPath(i));
            }
        } else {
            for (i = 0; i < packet.getPathCount(); ++i) {
                this.controller.getHoverExpressions().deselect(threadId, frameIndex, packet.getPath(i));
            }
        }
        HoverExpressionTreePacketImpl response = new HoverExpressionTreePacketImpl(this.controller.getHoverExpressions(), this.controller.getThreads().get(this.controller.getHoverExpressions().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), response);
    }

    @Override
    public void handle(VariableAssignmentFailurePacket packet) {
        assert (false);
    }

    @Override
    public void handle(ConditionalBreakpointFailurePacket packet) {
        assert (false);
    }

    @Override
    public void handle(HotCodeReplacementPacket packet) {
        assert (this.controller.isInTaskExecution());
        HashMap<String, byte[]> nameToBytes = new HashMap<String, byte[]>();
        for (int i = 0; i < packet.getNumberOfReplacements(); ++i) {
            nameToBytes.put(packet.getName(i), packet.getBytes(i));
        }
        String message = this.debugger.redefineClasses(nameToBytes);
        if (message != null) {
            QueueHelper.put(this.controller.getWriteQueue(), new HotCodeReplacementErrorPacketImpl(message));
        }
    }

    @Override
    public void handle(HotCodeReplacementErrorPacket packet) {
        assert (false);
    }

    @Override
    public void handle(ShutdownPacket packet) {
        assert (this.controller.isInTaskExecution());
        Thread shutdownThread = new Thread(new ShutdownHandler());
        shutdownThread.setDaemon(true);
        shutdownThread.start();
    }

    @Override
    public void handle(AddDetailFormattersPacket packet) {
        assert (this.controller.isInTaskExecution());
        HashMap<String, String> class2Expression = new HashMap<String, String>();
        for (int i = 0; i < packet.getNumberOfFormatters(); ++i) {
            class2Expression.put(packet.getClassName(i), packet.getExpression(i));
        }
        this.controller.getLocals().addDetailFormatters(class2Expression);
        this.controller.getExpressions().addDetailFormatters(class2Expression);
        assert (this.controller.getLocals().getDetailFormatters().equals(this.controller.getExpressions().getDetailFormatters()));
        this.updateVariablesAndSendPackets("Add-Detail-Formatter", new DetailFormattersListPacketImpl(this.controller.getLocals().getDetailFormatters()));
    }

    @Override
    public void handle(RemoveDetailFormattersPacket packet) {
        assert (this.controller.isInTaskExecution());
        String[] classNames = new String[packet.getNumberOfFormatters()];
        for (int i = 0; i < packet.getNumberOfFormatters(); ++i) {
            classNames[i] = packet.getClassName(i);
        }
        this.controller.getLocals().removeDetailFormatters(classNames);
        this.controller.getExpressions().removeDetailFormatters(classNames);
        assert (this.controller.getLocals().getDetailFormatters().equals(this.controller.getExpressions().getDetailFormatters()));
        this.updateVariablesAndSendPackets("Remove-Detail-Formatter", new DetailFormattersListPacketImpl(this.controller.getLocals().getDetailFormatters()));
    }

    @Override
    public void handle(DetailFormattersListPacket packet) {
        assert (false);
    }

    @Override
    public void handle(AddLogicalStructuresPacket packet) {
        assert (this.controller.isInTaskExecution());
        for (int i = 0; i < packet.getNumberOfLogicalStructures(); ++i) {
            this.controller.getLocals().addLogicalStructure(packet.getStructure(i));
            this.controller.getExpressions().addLogicalStructure(packet.getStructure(i));
        }
        assert (Arrays.equals(this.controller.getLocals().getLogicalStructures(), this.controller.getExpressions().getLogicalStructures()));
        this.updateVariablesAndSendPackets("Add-Logical-Structure", new LogicalStructuresListPacketImpl(this.controller.getLocals().getLogicalStructures()));
    }

    @Override
    public void handle(RemoveLogicalStructurePacket packet) {
        assert (this.controller.isInTaskExecution());
        for (int i = 0; i < packet.getNumberOfLogicalStructures(); ++i) {
            this.controller.getLocals().removeLogicalStructure(packet.getClassName(i));
            this.controller.getExpressions().removeLogicalStructure(packet.getClassName(i));
        }
        assert (Arrays.equals(this.controller.getLocals().getLogicalStructures(), this.controller.getExpressions().getLogicalStructures()));
        this.updateVariablesAndSendPackets("Remove-Logical-Structure", new LogicalStructuresListPacketImpl(this.controller.getLocals().getLogicalStructures()));
    }

    @Override
    public void handle(LogicalStructuresListPacket packet) {
        assert (false);
    }

    @Override
    public void handle(RefreshPacket packet) {
        assert (this.controller.isInTaskExecution());
        QueueHelper.put(this.controller.getWriteQueue(), new BreakpointListPacketImpl(this.controller.getBreakpoints().getBreakpoints()));
        assert (this.controller.getLocals().getDetailFormatters().equals(this.controller.getExpressions().getDetailFormatters()));
        QueueHelper.put(this.controller.getWriteQueue(), new DetailFormattersListPacketImpl(this.controller.getLocals().getDetailFormatters()));
        assert (Arrays.equals(this.controller.getLocals().getLogicalStructures(), this.controller.getExpressions().getLogicalStructures()));
        QueueHelper.put(this.controller.getWriteQueue(), new LogicalStructuresListPacketImpl(this.controller.getLocals().getLogicalStructures()));
        this.sendLocalsAndExpressions("Refresh");
        this.sendThreadList(true);
    }

    @Override
    public void handle(RequestDisassemblyByNamePacket packet) {
        AnnotatedPrintStream decompiledCode;
        AnnotatedPrintStream disassembly;
        assert (this.controller.isInTaskExecution());
        if (packet.includeDisassembly()) {
            try {
                disassembly = this.debugger.getDisassembly(packet.getClassName(), packet.getClassObjectId());
            }
            catch (RuntimeException e) {
                disassembly = this.debugger.createStream(packet.getClassName(), packet.getClassObjectId());
                disassembly.printStackTrace(e);
            }
        } else {
            disassembly = this.debugger.createStream(packet.getClassName(), packet.getClassObjectId());
            disassembly.println("Disassembly not supported.");
        }
        if (packet.includeDecompiledCode()) {
            try {
                decompiledCode = this.debugger.getDecompiledCode(packet.getClassName(), packet.getClassObjectId());
            }
            catch (RuntimeException e) {
                decompiledCode = this.debugger.createStream(packet.getClassName(), packet.getClassObjectId());
                decompiledCode.printStackTrace(e);
            }
        } else {
            decompiledCode = this.debugger.createStream(packet.getClassName(), packet.getClassObjectId());
            decompiledCode.println("Decompilation not supported.");
        }
        QueueHelper.put(this.controller.getWriteQueue(), new DisassembledClassPacketImpl(disassembly.getClassName(), disassembly.getClassObjectId(), disassembly.getResult(), disassembly.getAnnotations(), decompiledCode.getResult(), decompiledCode.getAnnotations()));
    }

    @Override
    public void handle(RequestDisassemblyByThreadPacket packet) {
        AnnotatedPrintStream decompiledCode;
        AnnotatedPrintStream disassembly;
        assert (this.controller.isInTaskExecution());
        ThreadHandle thread = this.controller.getThreads().get(packet.getThreadId());
        if (thread == null || !thread.isSuspended()) {
            return;
        }
        FrameHandle[] frames = thread.getFrames();
        if (frames.length <= packet.getFrameIndex()) {
            return;
        }
        ClassHandle clazz = frames[packet.getFrameIndex()].getMethodHandle().getClassHandle();
        if (packet.includeDisassembly()) {
            try {
                disassembly = this.debugger.getDisassembly(clazz);
            }
            catch (RuntimeException e) {
                disassembly = this.debugger.createStream(clazz.getDisplayName(), clazz.getId());
                disassembly.printStackTrace(e);
            }
        } else {
            disassembly = this.debugger.createStream(clazz.getDisplayName(), clazz.getId());
            disassembly.println("Disassembly not supported.");
        }
        if (packet.includeDecompiledCode()) {
            try {
                decompiledCode = this.debugger.getDecompiledCode(clazz);
            }
            catch (RuntimeException e) {
                decompiledCode = this.debugger.createStream(clazz.getDisplayName(), clazz.getId());
                decompiledCode.printStackTrace(e);
            }
        } else {
            decompiledCode = this.debugger.createStream(clazz.getDisplayName(), clazz.getId());
            decompiledCode.println("Decompilation not supported.");
        }
        QueueHelper.put(this.controller.getWriteQueue(), new DisassembledClassPacketImpl(disassembly.getClassName(), disassembly.getClassObjectId(), disassembly.getResult(), disassembly.getAnnotations(), decompiledCode.getResult(), decompiledCode.getAnnotations()));
    }

    @Override
    public void handle(DisassembledClassPacket packet) {
        assert (false);
    }

    @Override
    public void handle(BreakpointListPacket packet) {
        assert (this.controller.isInTaskExecution());
        BreakpointSpecification[] bp = packet.getBreakpoints();
        for (int i = 0; i < bp.length; ++i) {
            ThreadHandle thread;
            if (bp[i].getThreadToBeIgnored() == 0L || (thread = this.controller.getThreads().get(bp[i].getThreadToBeIgnored())) == null || !thread.isSuspended() || thread.getFrames().length <= 0) continue;
            BreakpointLocation location = thread.getFrames()[0].getLocation();
            BreakpointLocation[] oldLocations = bp[i].getIgnoredLocations();
            BreakpointLocation[] newLocations = new BreakpointLocation[oldLocations.length + 1];
            if (oldLocations.length > 0) {
                System.arraycopy(oldLocations, 0, newLocations, 0, oldLocations.length);
            }
            newLocations[newLocations.length - 1] = location;
            bp[i] = bp[i].setThreadToBeIgnored(0L).setIgnoredLocations(newLocations);
        }
        BreakpointListModel breakpoints = this.controller.getBreakpoints();
        breakpoints.update(bp, this.debugger, this.conditionListener);
        BreakpointListPacketImpl response = new BreakpointListPacketImpl(breakpoints.getBreakpoints());
        QueueHelper.put(this.controller.getWriteQueue(), response);
    }

    @Override
    public void handle(SkipAllBreakpointsPacket packet) {
        assert (this.controller.isInTaskExecution());
        this.debugger.setSkipAllBreakpoints(packet.skipAllBreakpoints());
    }

    @Override
    public void handle(ThreadListFilterPacket packet) {
        assert (this.controller.isInTaskExecution());
        ThreadListModel threads = this.controller.getThreads();
        if (threads.showRunningSystemThreads() != packet.showRunningSystemThreads()) {
            threads.setShowRunningSystemThreads(packet.showRunningSystemThreads());
        }
        if (threads.sendOnlyDeltas() != packet.sendOnlyDeltas()) {
            threads.setSendOnlyDeltas(packet.sendOnlyDeltas());
        }
        this.sendThreadList(true);
    }

    public void setController(DebuggingController controller) {
        this.controller = controller;
        controller.getThreads().addSelectionListener(this.selectionListener);
    }

    public void connect(SocketAdapter socket, boolean waitForStart) {
        assert (this.debugger == null);
        try {
            this.defaultWaitForStart = waitForStart;
            this.debugger = DebuggerFactory.connect(socket, new ThreadStateListenerImpl(), this.tracer.context(), this.sessionSuffix, waitForStart);
        }
        catch (IOException e) {
            this.tracer.warn((Throwable)e, "Connecting to socket failed");
            try {
                this.controller.stop();
            }
            catch (IOException e1) {
                this.tracer.warn((Throwable)e1, "Stopping debugging controller failed");
            }
        }
    }

    public void connect(String host, int port, boolean waitForStart) {
        assert (this.debugger == null);
        try {
            this.debugger = DebuggerFactory.connect(host, port, new ThreadStateListenerImpl(), this.tracer.context(), this.sessionSuffix, waitForStart);
        }
        catch (IOException e) {
            this.tracer.warn((Throwable)e, () -> "Connecting to debugging port failed (" + host + ":" + port + ")");
            try {
                this.controller.stop();
            }
            catch (IOException e1) {
                this.tracer.warn((Throwable)e1, "Stopping debugging controller failed");
            }
        }
    }

    public void connect(int pid, boolean waitForStart) {
        assert (this.debugger == null);
        try {
            MonitoredVm vm;
            try (MonitoringController tmpCtrl = new MonitoringController();){
                vm = tmpCtrl.getVmForPid(pid, true);
            }
            if (vm != null) {
                SocketAdapter adapter = vm.getDebuggingConnection(waitForStart);
                this.debugger = DebuggerFactory.connect(adapter, new ThreadStateListenerImpl(), this.tracer.context(), this.sessionSuffix, waitForStart);
            } else {
                this.tracer.warn(() -> "Could not find VM with pid " + pid);
            }
        }
        catch (IOException e) {
            this.tracer.warn((Throwable)e, () -> "Connecting to VM with pid " + pid + " failed");
            try {
                this.controller.stop();
            }
            catch (IOException e1) {
                this.tracer.warn((Throwable)e1, "Stopping debugging controller failed");
            }
        }
    }

    public void listen(int port, boolean waitForStart) {
        assert (this.debugger == null);
        try {
            this.debugger = DebuggerFactory.listen(port, new ThreadStateListenerImpl(), this.tracer.context(), this.sessionSuffix, waitForStart);
        }
        catch (IOException e) {
            this.tracer.warn((Throwable)e, () -> "Listening for debuggee connection requests on port (" + port + ") failed");
            try {
                this.controller.stop();
            }
            catch (IOException e1) {
                this.tracer.warn((Throwable)e1, "Stopping debugging controller failed");
            }
        }
    }

    private void sendThreadList(boolean forceCompleteList) {
        assert (this.controller.isInTaskExecution());
        ThreadListModel threads = this.controller.getThreads();
        ThreadListPacket packet = !forceCompleteList && threads.sendOnlyDeltas() ? new ThreadListDeltaPacketImpl(threads.getAddedThreads(), threads.getChangedThreads(), threads.getRemovedThreads(), threads.getSelectedThread(), threads.getSelectedFrame(), this.controller.getBreakpoints()) : new ThreadListPacketImpl(threads.getAll(), threads.getSelectedThread(), threads.getSelectedFrame(), this.controller.getBreakpoints());
        QueueHelper.put(this.controller.getWriteQueue(), packet);
        this.threadTracer.debug("Thread-Callback: Put new thread list packet into write queue.");
    }

    private void sendLocalsAndExpressions(String tracePrefix) {
        assert (this.controller.isInTaskExecution());
        AbstractVariableTreePacket packet = new ExpressionVariableTreePacketImpl(this.controller.getExpressions(), this.controller.getThreads().get(this.controller.getExpressions().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), packet);
        this.localTracer.debug(() -> tracePrefix + ": Put new expression variable tree packet into write queue.");
        packet = new HoverExpressionTreePacketImpl(this.controller.getHoverExpressions(), this.controller.getThreads().get(this.controller.getHoverExpressions().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), packet);
        this.localTracer.debug(() -> tracePrefix + ": Put new hover expression tree packet into write queue.");
        packet = new LocalVariableTreePacketImpl(this.controller.getLocals(), this.controller.getThreads().get(this.controller.getLocals().getThreadId()));
        QueueHelper.put(this.controller.getWriteQueue(), packet);
        this.localTracer.debug(() -> tracePrefix + ": Put new local variable tree packet into write queue.");
    }

    private void setExpression(AbstractVariableTreeModel tree, long threadId, int frameIndex, VariableTreeNode[] path, String expression, String trace) {
        assert (this.controller.isInTaskExecution());
        ThreadHandle thread = this.controller.getThreads().get(threadId);
        try {
            int index;
            tree.setExpression(thread, frameIndex, path, expression);
            if (thread != null && (index = Math.max(frameIndex, 0)) < thread.getFrames().length) {
                if (tree != this.controller.getExpressions()) {
                    this.controller.getExpressions().update(threadId, frameIndex, thread.getFrames()[index]);
                }
                this.controller.getLocals().update(threadId, frameIndex, thread.getFrames()[index]);
            }
            this.sendLocalsAndExpressions(trace);
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            String message = "Evaluation failed: ";
            message = cause instanceof ParseException && cause.getMessage() != null ? message + cause.getMessage() : message + cause.getClass().getName() + (cause.getMessage() != null ? " (" + cause.getMessage() + ")" : "");
            QueueHelper.put(this.controller.getWriteQueue(), new VariableAssignmentFailurePacketImpl(message));
        }
        catch (AssignmentException e) {
            String message = "Assignment failed: Expression value (" + e.getExpressionType() + ") is not compatible with declared type (" + e.getDeclaredType() + ")";
            QueueHelper.put(this.controller.getWriteQueue(), new VariableAssignmentFailurePacketImpl(message));
        }
    }

    private void updateVariablesAndSendPackets(String tracePrefix, DebuggingPacket packet) {
        LocalVariableTreeModel locals = this.controller.getLocals();
        ExpressionVariableTreeModel expressions = this.controller.getExpressions();
        ExpressionVariableTreeModel hoverExpressions = this.controller.getHoverExpressions();
        assert (locals.getThreadId() == expressions.getThreadId());
        assert (locals.getFrameIndex() == expressions.getFrameIndex());
        assert (locals.getThreadId() == hoverExpressions.getThreadId());
        assert (locals.getFrameIndex() == hoverExpressions.getFrameIndex());
        ThreadHandle thread = this.controller.getThreads().get(this.controller.getLocals().getThreadId());
        if (thread != null) {
            expressions.update(expressions.getThreadId(), expressions.getFrameIndex(), thread.getFrames()[expressions.getFrameIndex()]);
            hoverExpressions.update(hoverExpressions.getThreadId(), hoverExpressions.getFrameIndex(), thread.getFrames()[hoverExpressions.getFrameIndex()]);
            locals.update(locals.getThreadId(), locals.getFrameIndex(), thread.getFrames()[locals.getFrameIndex()]);
        }
        QueueHelper.put(this.controller.getWriteQueue(), packet);
        this.sendLocalsAndExpressions(tracePrefix);
    }

    private class ShutdownHandler
    implements Runnable {
        private ShutdownHandler() {
        }

        @Override
        public void run() {
            try {
                PacketHandlerImpl.this.controller.stop();
                Thread.sleep(30000L);
            }
            catch (IOException e) {
                PacketHandlerImpl.this.tracer.warn((Throwable)e, "Exception while shutting down controller");
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                System.exit(0);
            }
        }
    }

    private class ConditionFailureListenerImpl
    implements Breakpoint.ConditionFailureListener {
        private ConditionFailureListenerImpl() {
        }

        @Override
        public void conditionFailed(final Breakpoint breakpoint, final String message) {
            QueueHelper.put(PacketHandlerImpl.this.controller.getTaskQueue(), new Runnable(){

                @Override
                public void run() {
                    BreakpointNameWithType name = PacketHandlerImpl.this.controller.getBreakpoints().getName(breakpoint);
                    if (name != null) {
                        QueueHelper.put(PacketHandlerImpl.this.controller.getWriteQueue(), new ConditionalBreakpointFailurePacketImpl(name.getName(), name.getType(), message));
                    }
                }
            });
        }
    }

    private class ThreadSelectionChangeListenerImpl
    implements ThreadListModel.ThreadSelectionChangeListener {
        private ThreadSelectionChangeListenerImpl() {
        }

        @Override
        public void selectionChanged(long id, int frameIndex, FrameHandle frame) {
            assert (PacketHandlerImpl.this.controller.isInTaskExecution());
            ThreadHandle thread = PacketHandlerImpl.this.controller.getThreads().get(id);
            if (thread == null) {
                PacketHandlerImpl.this.localTracer.debug("Thread-Selection-Change: Received new thread selection: no thread selected");
            } else {
                PacketHandlerImpl.this.localTracer.debug(() -> "Thread-Selection-Change: Received new thread selection: " + thread.getName());
            }
            PacketHandlerImpl.this.controller.getExpressions().update(id, frameIndex, frame);
            PacketHandlerImpl.this.controller.getHoverExpressions().update(id, frameIndex, frame == null ? null : thread.getFrames()[Math.max(frameIndex, 0)]);
            PacketHandlerImpl.this.controller.getLocals().update(id, frameIndex, frame == null ? null : thread.getFrames()[Math.max(frameIndex, 0)]);
            PacketHandlerImpl.this.sendLocalsAndExpressions("Thread-Selection-Change");
            if (frame != null && !PacketHandlerImpl.this.delayedPackets.isEmpty()) {
                while (!PacketHandlerImpl.this.delayedPackets.isEmpty()) {
                    DebuggingPacket packet = (DebuggingPacket)PacketHandlerImpl.this.delayedPackets.remove();
                    if (packet instanceof AddExpressionPacket) {
                        PacketHandlerImpl.this.handle((AddExpressionPacket)packet);
                        continue;
                    }
                    if (packet instanceof ChangeExpressionPacket) {
                        PacketHandlerImpl.this.handle((ChangeExpressionPacket)packet);
                        continue;
                    }
                    if (packet instanceof RemoveExpressionPacket) {
                        PacketHandlerImpl.this.handle((RemoveExpressionPacket)packet);
                        continue;
                    }
                    PacketHandlerImpl.this.tracer.warn("Unexpected packet " + packet);
                }
            }
        }
    }

    private class ThreadStateListenerImpl
    implements ThreadStateListener {
        private ThreadStateListenerImpl() {
        }

        @Override
        public void threadStateChanged(Debugger d, final ThreadChanges change) {
            int j;
            String state;
            ThreadHandle thread;
            PacketHandlerImpl.this.threadTracer.debug("Thread-Callback: Received thread change");
            int i = 0;
            while (i < change.getStartedThreads().length) {
                thread = change.getStartedThreads()[i];
                state = thread.isStepping() ? "stepping" : (thread.isSuspended() ? "suspended" : "running");
                j = i++;
                PacketHandlerImpl.this.threadTracer.debug("Thread-Callback started:    %d %s [%s]", new Object[]{j, thread.getName(), state});
            }
            i = 0;
            while (i < change.getStoppedThreads().length) {
                thread = change.getStoppedThreads()[i];
                state = thread.isStepping() ? "stepping" : (thread.isSuspended() ? "suspended" : "running");
                j = i++;
                PacketHandlerImpl.this.threadTracer.debug("Thread-Callback stopped:    %d %s [%s]", new Object[]{j, thread.getName(), state});
            }
            i = 0;
            while (i < change.getChangedThreads().length) {
                thread = change.getChangedThreads()[i];
                state = thread.isStepping() ? "stepping" : (thread.isSuspended() ? "suspended" : "running");
                j = i++;
                PacketHandlerImpl.this.threadTracer.debug("Thread-Callback changed:    %d %s [%s]", new Object[]{j, thread.getName(), state});
            }
            QueueHelper.put(PacketHandlerImpl.this.controller.getTaskQueue(), new Runnable(){

                @Override
                public void run() {
                    PacketHandlerImpl.this.controller.getThreads().update(change);
                    PacketHandlerImpl.this.sendThreadList(false);
                    PacketHandlerImpl.this.controller.getThreads().clearDelta();
                }
            });
        }

        @Override
        public void vmDisconnected() {
            while (!PacketHandlerImpl.this.controller.isFinished() && !PacketHandlerImpl.this.controller.getTaskQueue().isEmpty()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            while (!PacketHandlerImpl.this.controller.isFinished() && !PacketHandlerImpl.this.controller.getWriteQueue().isEmpty()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                PacketHandlerImpl.this.controller.stop();
            }
            catch (IOException e) {
                PacketHandlerImpl.this.tracer.warn((Throwable)e, "Could not stop");
            }
        }
    }
}

