/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.controller.packets.ThreadListPacket;
import com.sap.jvm.debugging.types.ThreadGroupHandle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ThreadGroupInfoImpl
implements ThreadListPacket.ThreadGroupInfo {
    private final long id;
    private final String name;
    private final ThreadListPacket.ThreadGroupInfo parent;

    public static Map<Long, ThreadGroupInfoImpl> read(DataInputStream in) throws IOException {
        HashMap<Long, ThreadGroupInfoImpl> result = new HashMap<Long, ThreadGroupInfoImpl>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            ThreadGroupInfoImpl group = new ThreadGroupInfoImpl(in, result);
            ThreadGroupInfoImpl old = result.put(group.getId(), group);
            assert (old == null);
        }
        return result;
    }

    public static void write(ThreadGroupInfoImpl[] groups, DataOutputStream out) throws IOException {
        ThreadGroupInfoImpl g;
        HashMap<Long, ThreadGroupInfoImpl> groupsById = new HashMap<Long, ThreadGroupInfoImpl>();
        HashMap<Long, HashSet<ThreadGroupInfoImpl>> children = new HashMap<Long, HashSet<ThreadGroupInfoImpl>>();
        HashSet<Long> topLevelGroups = new HashSet<Long>();
        ThreadGroupInfoImpl[] threadGroupInfoImplArray = groups;
        int n = threadGroupInfoImplArray.length;
        block0: for (int i = 0; i < n; ++i) {
            ThreadGroupInfoImpl current = g = threadGroupInfoImplArray[i];
            while (!groupsById.containsKey(current.getId())) {
                groupsById.put(current.getId(), current);
                ThreadGroupInfoImpl parentGroup = (ThreadGroupInfoImpl)current.getParent();
                if (parentGroup == null) {
                    topLevelGroups.add(current.getId());
                    continue block0;
                }
                HashSet<ThreadGroupInfoImpl> childrenOfParent = (HashSet<ThreadGroupInfoImpl>)children.get(parentGroup.getId());
                if (childrenOfParent == null) {
                    childrenOfParent = new HashSet<ThreadGroupInfoImpl>();
                    children.put(parentGroup.getId(), childrenOfParent);
                }
                childrenOfParent.add(current);
                current = parentGroup;
            }
        }
        out.writeInt(groupsById.size());
        int written = 0;
        for (Long groupId : topLevelGroups) {
            g = (ThreadGroupInfoImpl)groupsById.get(groupId);
            g.write(out);
            ++written;
            ArrayList toBeWritten = new ArrayList();
            Set toBeAdded = (Set)children.get(g.getId());
            if (toBeAdded != null) {
                toBeWritten.addAll(toBeAdded);
            }
            while (!toBeWritten.isEmpty()) {
                ThreadGroupInfoImpl[] next = toBeWritten.toArray(new ThreadGroupInfoImpl[toBeWritten.size()]);
                toBeWritten.clear();
                for (ThreadGroupInfoImpl child : next) {
                    child.write(out);
                    ++written;
                    toBeAdded = (Set)children.get(child.getId());
                    if (toBeAdded == null) continue;
                    toBeWritten.addAll(toBeAdded);
                }
            }
        }
        assert (groupsById.size() == written);
    }

    private ThreadGroupInfoImpl(DataInputStream in, Map<Long, ThreadGroupInfoImpl> groups) throws IOException {
        this.id = in.readLong();
        this.name = in.readUTF();
        this.parent = in.readBoolean() ? (ThreadListPacket.ThreadGroupInfo)groups.get(in.readLong()) : null;
    }

    public ThreadGroupInfoImpl(ThreadGroupHandle group) {
        this.id = group.getId();
        this.name = group.getName();
        ThreadGroupHandle parentHandle = group.getParent();
        this.parent = parentHandle == null ? null : new ThreadGroupInfoImpl(parentHandle);
    }

    private void write(DataOutputStream out) throws IOException {
        out.writeLong(this.id);
        out.writeUTF(this.name);
        out.writeBoolean(this.parent != null);
        if (this.parent != null) {
            out.writeLong(this.parent.getId());
        }
    }

    public void print(PrintStream stream) {
        stream.println("        Thread group identifier   : " + this.id);
        stream.println("        Thread group name         : " + this.name);
        stream.println("        Parent thread group id    : " + (this.parent == null ? "none" : Long.valueOf(this.parent.getId())));
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ThreadListPacket.ThreadGroupInfo getParent() {
        return this.parent;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadGroupInfoImpl other = (ThreadGroupInfoImpl)obj;
        return this.id == other.id;
    }
}

