/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.impl.packets;

import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.controller.impl.packets.ActiveBreakpointImpl;
import com.sap.jvm.debugging.controller.impl.packets.FrameImpl;
import com.sap.jvm.debugging.controller.impl.packets.ObjectMonitorImpl;
import com.sap.jvm.debugging.controller.impl.packets.ThreadGroupInfoImpl;
import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.ThreadListDeltaPacket;
import com.sap.jvm.debugging.controller.packets.ThreadListPacket;
import com.sap.jvm.debugging.presentation.BreakpointNameService;
import com.sap.jvm.debugging.presentation.BreakpointNameWithType;
import com.sap.jvm.debugging.presentation.BreakpointType;
import com.sap.jvm.debugging.types.FrameHandle;
import com.sap.jvm.debugging.types.ObjectHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ThreadListDeltaPacketImpl
implements ThreadListDeltaPacket {
    private static final FrameImpl[] NO_FRAMES = new FrameImpl[0];
    private static final ActiveBreakpointImpl[] NO_BREAKPOINTS = new ActiveBreakpointImpl[0];
    private static final ObjectMonitorImpl[] NO_MONITORS = new ObjectMonitorImpl[0];
    private final long[] ids;
    private final String[] names;
    private final boolean[] suspended;
    private final boolean[] stepping;
    private final boolean[] hasEndedStep;
    private final boolean[] daemon;
    private final boolean[] system;
    private final int selection;
    private final FrameImpl[][] frames;
    private final ActiveBreakpointImpl[][] breakpoints;
    private final ObjectMonitorImpl[] contendedMonitor;
    private final ObjectMonitorImpl[] waitingMonitor;
    private final ObjectMonitorImpl[][] ownedMonitors;
    private final ThreadGroupInfoImpl[] threadGroups;
    private final boolean[] isNew;
    private final boolean[] isModified;
    private final boolean[] isDead;

    public static ThreadListDeltaPacketImpl read(DataInputStream in) throws IOException {
        return new ThreadListDeltaPacketImpl(in);
    }

    private ThreadListDeltaPacketImpl(DataInputStream in) throws IOException {
        DataInputStream input = new DataInputStream(new GZIPInputStream(in));
        int size = input.readInt();
        this.ids = new long[size];
        this.names = new String[size];
        this.suspended = new boolean[size];
        this.stepping = new boolean[size];
        this.hasEndedStep = new boolean[size];
        this.daemon = new boolean[size];
        this.system = new boolean[size];
        this.frames = new FrameImpl[size][];
        this.breakpoints = new ActiveBreakpointImpl[size][];
        this.contendedMonitor = new ObjectMonitorImpl[size];
        this.waitingMonitor = new ObjectMonitorImpl[size];
        this.ownedMonitors = new ObjectMonitorImpl[size][];
        this.threadGroups = new ThreadGroupInfoImpl[size];
        long[] threadGroupIds = new long[size];
        this.isNew = new boolean[size];
        this.isModified = new boolean[size];
        this.isDead = new boolean[size];
        for (int i = 0; i < size; ++i) {
            this.ids[i] = input.readLong();
            this.names[i] = input.readUTF();
            this.suspended[i] = input.readBoolean();
            this.stepping[i] = input.readBoolean();
            this.hasEndedStep[i] = input.readBoolean();
            this.daemon[i] = input.readBoolean();
            this.system[i] = input.readBoolean();
            int stackSize = input.readInt();
            this.frames[i] = stackSize > 0 ? new FrameImpl[stackSize] : NO_FRAMES;
            for (int j = 0; j < stackSize; ++j) {
                this.frames[i][j] = new FrameImpl(input);
            }
            int breakpointSize = input.readInt();
            this.breakpoints[i] = breakpointSize > 0 ? new ActiveBreakpointImpl[breakpointSize] : NO_BREAKPOINTS;
            for (int j = 0; j < breakpointSize; ++j) {
                this.breakpoints[i][j] = new ActiveBreakpointImpl(input);
            }
            this.contendedMonitor[i] = input.readBoolean() ? new ObjectMonitorImpl(input) : null;
            this.waitingMonitor[i] = input.readBoolean() ? new ObjectMonitorImpl(input) : null;
            int monitorSize = input.readInt();
            this.ownedMonitors[i] = monitorSize > 0 ? new ObjectMonitorImpl[monitorSize] : NO_MONITORS;
            for (int j = 0; j < monitorSize; ++j) {
                this.ownedMonitors[i][j] = new ObjectMonitorImpl(input);
            }
            threadGroupIds[i] = input.readLong();
            this.isNew[i] = input.readBoolean();
            this.isModified[i] = input.readBoolean();
            this.isDead[i] = input.readBoolean();
        }
        this.selection = input.readInt();
        Map<Long, ThreadGroupInfoImpl> groups = ThreadGroupInfoImpl.read(input);
        for (int i = 0; i < size; ++i) {
            this.threadGroups[i] = groups.get(threadGroupIds[i]);
            if (this.threadGroups[i] != null) continue;
            throw new IllegalStateException("Thread group not found: id=" + threadGroupIds[i]);
        }
    }

    public ThreadListDeltaPacketImpl(ThreadHandle[] newThreads, ThreadHandle[] modifiedThreads, ThreadHandle[] removedThreads, long selectedId, int selectedFrame, BreakpointNameService nameService) {
        int size = newThreads.length + modifiedThreads.length + removedThreads.length;
        this.ids = new long[size];
        this.names = new String[size];
        this.suspended = new boolean[size];
        this.stepping = new boolean[size];
        this.hasEndedStep = new boolean[size];
        this.daemon = new boolean[size];
        this.system = new boolean[size];
        this.frames = new FrameImpl[size][];
        this.breakpoints = new ActiveBreakpointImpl[size][];
        this.contendedMonitor = new ObjectMonitorImpl[size];
        this.waitingMonitor = new ObjectMonitorImpl[size];
        this.ownedMonitors = new ObjectMonitorImpl[size][];
        this.threadGroups = new ThreadGroupInfoImpl[size];
        this.isNew = new boolean[size];
        this.isModified = new boolean[size];
        this.isDead = new boolean[size];
        int selectedThread = -1;
        for (int i = 0; i < size; ++i) {
            boolean isSelected;
            ThreadHandle[] list;
            ThreadHandle thread;
            if (i < newThreads.length) {
                thread = newThreads[i];
                list = newThreads;
            } else if (i < newThreads.length + modifiedThreads.length) {
                thread = modifiedThreads[i - newThreads.length];
                list = modifiedThreads;
            } else {
                assert (i < newThreads.length + modifiedThreads.length + removedThreads.length);
                thread = removedThreads[i - newThreads.length - modifiedThreads.length];
                list = removedThreads;
            }
            this.ids[i] = thread.getId();
            boolean bl = isSelected = this.ids[i] == selectedId;
            if (isSelected) {
                assert (selectedThread == -1);
                selectedThread = i;
            }
            this.names[i] = thread.getName();
            this.suspended[i] = thread.isSuspended();
            this.stepping[i] = thread.isStepping();
            this.hasEndedStep[i] = thread.hasEndedStep();
            this.daemon[i] = thread.isDaemon();
            this.system[i] = thread.isSystem();
            FrameHandle[] stack = thread.getFrames();
            this.frames[i] = stack.length > 0 ? new FrameImpl[stack.length] : NO_FRAMES;
            for (int j = 0; j < stack.length; ++j) {
                this.frames[i][j] = new FrameImpl(stack[j], isSelected && selectedFrame == j);
            }
            Breakpoint[] breakpointsHit = thread.getBreakpointsHit();
            this.breakpoints[i] = breakpointsHit.length > 0 ? new ActiveBreakpointImpl[breakpointsHit.length] : NO_BREAKPOINTS;
            for (int j = 0; j < breakpointsHit.length; ++j) {
                BreakpointNameWithType name = nameService.getName(breakpointsHit[j]);
                if (name == null) {
                    name = new BreakpointNameWithType("deleted breakpoint", BreakpointType.LINE);
                }
                this.breakpoints[i][j] = new ActiveBreakpointImpl(breakpointsHit[j], name.getName(), name.getType());
            }
            this.contendedMonitor[i] = thread.getContendedMonitor() == null ? null : new ObjectMonitorImpl(thread.getContendedMonitor());
            this.waitingMonitor[i] = thread.getWaitingMonitor() == null ? null : new ObjectMonitorImpl(thread.getWaitingMonitor());
            ObjectHandle[] monitors = thread.getOwnedMonitors();
            this.ownedMonitors[i] = monitors.length > 0 ? new ObjectMonitorImpl[monitors.length] : NO_MONITORS;
            for (int j = 0; j < monitors.length; ++j) {
                this.ownedMonitors[i][j] = new ObjectMonitorImpl(monitors[j]);
            }
            this.threadGroups[i] = new ThreadGroupInfoImpl(thread.getThreadGroup());
            this.isNew[i] = list == newThreads;
            this.isModified[i] = list == modifiedThreads;
            this.isDead[i] = list == removedThreads;
        }
        this.selection = selectedThread;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.THREAD_LIST_DELTA_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        assert (this.ids.length == this.names.length && this.names.length == this.suspended.length && this.suspended.length == this.stepping.length && this.stepping.length == this.daemon.length && this.daemon.length == this.system.length && this.system.length == this.frames.length && this.frames.length == this.breakpoints.length && this.breakpoints.length == this.contendedMonitor.length && this.contendedMonitor.length == this.waitingMonitor.length && this.waitingMonitor.length == this.ownedMonitors.length && this.ownedMonitors.length == this.threadGroups.length && this.threadGroups.length == this.isNew.length && this.isNew.length == this.isModified.length && this.isModified.length == this.isDead.length);
        GZIPOutputStream zipOut = new GZIPOutputStream(out);
        DataOutputStream output = new DataOutputStream(zipOut);
        output.writeInt(this.ids.length);
        for (int i = 0; i < this.names.length; ++i) {
            int j;
            output.writeLong(this.ids[i]);
            output.writeUTF(this.names[i]);
            output.writeBoolean(this.suspended[i]);
            output.writeBoolean(this.stepping[i]);
            output.writeBoolean(this.hasEndedStep[i]);
            output.writeBoolean(this.daemon[i]);
            output.writeBoolean(this.system[i]);
            output.writeInt(this.frames[i].length);
            for (j = 0; j < this.frames[i].length; ++j) {
                this.frames[i][j].write(output);
            }
            output.writeInt(this.breakpoints[i].length);
            for (j = 0; j < this.breakpoints[i].length; ++j) {
                this.breakpoints[i][j].write(output);
            }
            output.writeBoolean(this.contendedMonitor[i] != null);
            if (this.contendedMonitor[i] != null) {
                this.contendedMonitor[i].write(output);
            }
            output.writeBoolean(this.waitingMonitor[i] != null);
            if (this.waitingMonitor[i] != null) {
                this.waitingMonitor[i].write(output);
            }
            output.writeInt(this.ownedMonitors[i].length);
            for (j = 0; j < this.ownedMonitors[i].length; ++j) {
                this.ownedMonitors[i][j].write(output);
            }
            output.writeLong(this.threadGroups[i].getId());
            output.writeBoolean(this.isNew[i]);
            output.writeBoolean(this.isModified[i]);
            output.writeBoolean(this.isDead[i]);
        }
        output.writeInt(this.selection);
        ThreadGroupInfoImpl.write((ThreadGroupInfoImpl[])this.threadGroups.clone(), output);
        zipOut.finish();
        output.flush();
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Selected thread identifier    : " + (this.selection < 0 ? "none" : Integer.valueOf(this.selection)));
        for (int i = 0; i < this.names.length; ++i) {
            int j;
            stream.println("    " + (i + 1) + ". Thread");
            stream.println("        Thread identifier         : " + this.ids[i]);
            stream.println("        Thread name               : " + this.names[i]);
            stream.println("        Suspended                 : " + (this.suspended[i] ? "yes" : "no"));
            stream.println("        Stepping                  : " + (this.stepping[i] ? "yes" : "no"));
            stream.println("        Has ended step            : " + (this.hasEndedStep[i] ? "yes" : "no"));
            stream.println("        Selected                  : " + (this.selection == i ? "yes" : "no"));
            stream.println("        Daemon thread             : " + (this.daemon[i] ? "yes" : "no"));
            stream.println("        System thread             : " + (this.system[i] ? "yes" : "no"));
            for (j = 0; j < this.frames[i].length; ++j) {
                stream.println("        " + (j + 1) + ". Stackframe");
                this.frames[i][j].print(stream);
            }
            for (j = 0; j < this.breakpoints[i].length; ++j) {
                stream.println("        " + (j + 1) + ". Active breakpoint");
                this.breakpoints[i][j].print(stream);
            }
            stream.println("        Contended object monitor  : " + (this.contendedMonitor[i] != null ? this.contendedMonitor[i] : "none"));
            stream.println("        Waiting object monitor    : " + (this.waitingMonitor[i] != null ? this.waitingMonitor[i] : "none"));
            for (j = 0; j < this.ownedMonitors[i].length; ++j) {
                stream.println("        " + (j + 1) + ". Owned object monitor   : " + this.ownedMonitors[i][j].getText());
            }
            this.threadGroups[i].print(stream);
            stream.println("        Thread newly added        : " + (this.isNew[i] ? "yes" : "no"));
            stream.println("        Thread recently modified  : " + (this.isModified[i] ? "yes" : "no"));
            stream.println("        Thread recently removed   : " + (this.isDead[i] ? "yes" : "no"));
        }
    }

    @Override
    public int getThreadCount() {
        assert (this.ids.length == this.names.length && this.names.length == this.suspended.length && this.suspended.length == this.stepping.length && this.stepping.length == this.daemon.length && this.daemon.length == this.system.length && this.system.length == this.frames.length && this.frames.length == this.breakpoints.length && this.breakpoints.length == this.contendedMonitor.length && this.contendedMonitor.length == this.waitingMonitor.length && this.waitingMonitor.length == this.ownedMonitors.length && this.ownedMonitors.length == this.threadGroups.length && this.threadGroups.length == this.isNew.length && this.isNew.length == this.isModified.length && this.isModified.length == this.isDead.length);
        return this.names.length;
    }

    @Override
    public long getThreadId(int index) {
        return this.ids[index];
    }

    @Override
    public String getThreadName(int index) {
        return this.names[index];
    }

    @Override
    public boolean isSuspended(int index) {
        return this.suspended[index];
    }

    @Override
    public boolean isStepping(int index) {
        return this.stepping[index];
    }

    @Override
    public boolean hasEndedStep(int index) {
        return this.hasEndedStep[index];
    }

    @Override
    public boolean isDaemon(int index) {
        return this.daemon[index];
    }

    @Override
    public boolean isSystem(int index) {
        return this.system[index];
    }

    @Override
    public boolean isSelected(int index) {
        return index >= 0 && index == this.selection;
    }

    @Override
    public ThreadListPacket.Frame[] getThreadFrames(int index) {
        return this.frames[index];
    }

    @Override
    public ThreadListPacket.ActiveBreakpoint[] getActiveBreakpoints(int index) {
        return this.breakpoints[index];
    }

    @Override
    public ThreadListPacket.ObjectMonitor getContendedMonitor(int index) {
        return this.contendedMonitor[index];
    }

    @Override
    public ThreadListPacket.ObjectMonitor getWaitingMonitor(int index) {
        return this.waitingMonitor[index];
    }

    @Override
    public ThreadListPacket.ObjectMonitor[] getOwnedMonitors(int index) {
        return this.ownedMonitors[index];
    }

    @Override
    public ThreadListPacket.ThreadGroupInfo getThreadGroup(int index) {
        return this.threadGroups[index];
    }

    @Override
    public boolean isThreadNew(int index) {
        return this.isNew[index];
    }

    @Override
    public boolean isThreadModified(int index) {
        return this.isModified[index];
    }

    @Override
    public boolean isThreadDead(int index) {
        return this.isDead[index];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.daemon);
        result = 31 * result + Arrays.hashCode(this.system);
        result = 31 * result + Arrays.hashCode(this.ids);
        result = 31 * result + Arrays.hashCode(this.names);
        result = 31 * result + Arrays.hashCode(this.suspended);
        result = 31 * result + Arrays.hashCode(this.stepping);
        result = 31 * result + Arrays.hashCode(this.hasEndedStep);
        result = 31 * result + Arrays.deepHashCode((Object[])this.frames);
        result = 31 * result + Arrays.deepHashCode((Object[])this.breakpoints);
        result = 31 * result + Arrays.hashCode(this.contendedMonitor);
        result = 31 * result + Arrays.hashCode(this.waitingMonitor);
        result = 31 * result + Arrays.deepHashCode((Object[])this.ownedMonitors);
        result = 31 * result + Arrays.hashCode(this.threadGroups);
        result = 31 * result + Arrays.hashCode(this.isNew);
        result = 31 * result + Arrays.hashCode(this.isModified);
        result = 31 * result + Arrays.hashCode(this.isDead);
        result = 31 * result + this.selection;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadListDeltaPacketImpl other = (ThreadListDeltaPacketImpl)obj;
        return this.selection == other.selection && Arrays.equals(this.daemon, other.daemon) && Arrays.equals(this.system, other.system) && Arrays.equals(this.ids, other.ids) && Arrays.equals(this.names, other.names) && Arrays.equals(this.suspended, other.suspended) && Arrays.equals(this.stepping, other.stepping) && Arrays.equals(this.hasEndedStep, other.hasEndedStep) && Arrays.deepEquals((Object[])this.frames, (Object[])other.frames) && Arrays.deepEquals((Object[])this.breakpoints, (Object[])other.breakpoints) && Arrays.equals(this.contendedMonitor, other.contendedMonitor) && Arrays.equals(this.waitingMonitor, other.waitingMonitor) && Arrays.deepEquals((Object[])this.ownedMonitors, (Object[])other.ownedMonitors) && Arrays.equals(this.threadGroups, other.threadGroups) && Arrays.equals(this.isNew, other.isNew) && Arrays.equals(this.isModified, other.isModified) && Arrays.equals(this.isDead, other.isDead);
    }
}

