/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.io;

import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.cloud.CloudService;
import com.sap.jvm.util.http.HttpPoller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public final class CloudDebuggingPoller
implements HttpPoller {
    private static final int POLL_PERIOD_MS = 1000;
    private static final int REQUEST_SPLIT_SIZE_BYTES = 5000;
    private final BlockingQueue<byte[]> output = new LinkedBlockingQueue<byte[]>();
    private final BlockingQueue<byte[]> input = new LinkedBlockingQueue<byte[]>();
    private final CloudInputStream is = new CloudInputStream();
    private final CloudOutputStream os = new CloudOutputStream();
    private final Object sync = new Object();
    private final byte[] endOfInput = new byte[0];
    private volatile boolean finished = false;
    private final Tracer tracer;
    private final CloudService theCloudService;

    public CloudDebuggingPoller(CloudService cloudService, Object traceContext) {
        this.theCloudService = cloudService;
        this.tracer = Trace.get((String)CloudDebuggingPoller.class.getName(), (Object)traceContext);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                CloudDebuggingPoller.this.run();
            }
        }, "Cloud-Debugging-Poller");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        byte[] nextBuffer = null;
        while (!this.finished) {
            try {
                Map<String, String> parameters = this.theCloudService.getParameters();
                byte[] buffer = nextBuffer != null ? nextBuffer : (byte[])this.output.poll();
                nextBuffer = null;
                int dataCounter = 0;
                long dataSize = 0L;
                while (buffer != null || (buffer = (byte[])this.output.poll()) != null) {
                    if (dataSize + (long)buffer.length > 5000L) {
                        this.tracer.debug("Request too large => Splitting it...");
                        byte[] tmpBuffer = new byte[(int)(5000L - dataSize)];
                        nextBuffer = new byte[buffer.length - tmpBuffer.length];
                        System.arraycopy(buffer, 0, tmpBuffer, 0, tmpBuffer.length);
                        System.arraycopy(buffer, tmpBuffer.length, nextBuffer, 0, nextBuffer.length);
                        buffer = tmpBuffer;
                    }
                    parameters.put("debugdata" + Integer.toString(dataCounter++), this.theCloudService.encode(buffer));
                    buffer = null;
                    if ((dataSize += (long)buffer.length) != 5000L) continue;
                }
                parameters.put("debugdatacount", Integer.toString(dataCounter));
                if (nextBuffer != null) {
                    parameters.put("moredebugdata", Boolean.toString(true));
                }
                this.theCloudService.getNextPackages(this.input, parameters, this.tracer, 1000);
                Object object = this.sync;
                synchronized (object) {
                    if (nextBuffer != null || !this.output.isEmpty()) {
                        continue;
                    }
                    try {
                        this.sync.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException | URISyntaxException e) {
                this.finished = true;
                this.tracer.error((Throwable)e, "Error while polling for debugging information");
            }
        }
        this.input.add(this.endOfInput);
    }

    private class CloudOutputStream
    extends OutputStream {
        private CloudOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (CloudDebuggingPoller.this.finished) {
                throw new IOException("Connection closed");
            }
            byte[] value = new byte[]{(byte)b};
            CloudDebuggingPoller.this.output.add(value);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (CloudDebuggingPoller.this.finished) {
                throw new IOException("Connection closed");
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (off > b.length || off < 0 || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            byte[] value = new byte[len];
            System.arraycopy(b, off, value, 0, len);
            CloudDebuggingPoller.this.output.add(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Object object = CloudDebuggingPoller.this.sync;
            synchronized (object) {
                CloudDebuggingPoller.this.sync.notifyAll();
            }
        }

        @Override
        public void close() throws IOException {
            CloudDebuggingPoller.this.finished = true;
        }
    }

    private class CloudInputStream
    extends InputStream {
        private byte[] current = null;
        private int offset = -1;

        private CloudInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (CloudDebuggingPoller.this.finished) {
                return -1;
            }
            this.getNextBuffer();
            if (this.current == CloudDebuggingPoller.this.endOfInput) {
                assert (CloudDebuggingPoller.this.finished);
                this.current = null;
                this.offset = -1;
                return -1;
            }
            byte result = this.current[this.offset++];
            if (this.offset >= this.current.length) {
                this.current = null;
                this.offset = -1;
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int count;
            if (b == null) {
                throw new NullPointerException();
            }
            if (len < 0 || off > b.length || off < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (CloudDebuggingPoller.this.finished) {
                return -1;
            }
            this.getNextBuffer();
            if (this.current == CloudDebuggingPoller.this.endOfInput) {
                assert (CloudDebuggingPoller.this.finished);
                this.current = null;
                this.offset = -1;
                return -1;
            }
            for (count = 0; count < len; ++count) {
                b[off + count] = this.current[this.offset++];
                if (this.offset < this.current.length) continue;
                this.current = null;
                this.offset = -1;
                break;
            }
            return count;
        }

        private synchronized void getNextBuffer() {
            if (this.current != null) {
                return;
            }
            while (this.current == null) {
                try {
                    this.current = (byte[])CloudDebuggingPoller.this.input.take();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.offset = 0;
        }

        @Override
        public int available() throws IOException {
            return CloudDebuggingPoller.this.input.isEmpty() ? 0 : 1;
        }

        @Override
        public void close() throws IOException {
            CloudDebuggingPoller.this.finished = true;
        }
    }
}

