/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.io;

import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.tracing.Trace;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;

public final class PacketFileWriter
implements Runnable {
    public static final long POLLING_PERIOD_MS = 500L;
    public static final int TIMESTAMP_SIZE = 8;
    private final DataOutputStream out;
    private volatile boolean closed = false;
    private volatile boolean finished = false;
    private final BlockingQueue<DebuggingPacket> packetQueue;
    private volatile long writtenPackets = 0L;
    private final boolean TRACE = Boolean.getBoolean("com.sap.jvm.debugging.controller.io.file.writer.trace");
    private final boolean TRACE_FULL = Boolean.getBoolean("com.sap.jvm.debugging.controller.io.file.writer.trace.full");

    public PacketFileWriter(String file, BlockingQueue<DebuggingPacket> queue) throws IOException {
        this.out = new DataOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
        this.packetQueue = queue;
    }

    @Override
    public void run() {
        block10: {
            try {
                this.trace("FileWriter: Waiting for new packet...", new Object[0]);
                while (!this.closed) {
                    try {
                        DebuggingPacket packet = this.packetQueue.poll(500L, TimeUnit.MILLISECONDS);
                        if (packet == null) continue;
                        this.writePacket(packet);
                        this.trace("FileWriter: Waiting for new packet...", new Object[0]);
                    }
                    catch (InterruptedException packet) {}
                }
                this.out.close();
            }
            catch (IOException e) {
                if (this.closed) break block10;
                this.closed = true;
                try {
                    this.out.close();
                }
                catch (IOException e1) {
                    Trace.warn((Throwable)e1, (String)"Exception while closing output stream of packet writer");
                }
                Trace.warn((Throwable)e, (String)"Exception while writing packets");
            }
            finally {
                this.trace("FileWriter: Stopped.", new Object[0]);
                this.finished = true;
            }
        }
    }

    public void stop() {
        this.trace("FileWriter: Stopping...", new Object[0]);
        this.closed = true;
    }

    private void writePacket(DebuggingPacket packet) throws IOException {
        long timestamp = System.currentTimeMillis();
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        packet.write(new DataOutputStream(bufferStream));
        byte[] data = bufferStream.toByteArray();
        int type = packet.getType().get();
        int size = data.length + 8;
        bufferStream = new ByteArrayOutputStream();
        DataOutputStream tmp = new DataOutputStream(bufferStream);
        tmp.writeLong(timestamp);
        tmp.writeInt(type);
        tmp.writeInt(size);
        byte[] header = bufferStream.toByteArray();
        assert (header.length == 16);
        byte[] packetData = new byte[data.length + header.length];
        System.arraycopy(header, 0, packetData, 0, header.length);
        System.arraycopy(data, 0, packetData, header.length, data.length);
        this.trace("FileWriter: Dumping packet %s (type=%d, size=%d)...", new Object[]{packet.getType(), packet.getType().get(), packetData.length});
        if (this.TRACE_FULL) {
            packet.print(System.err);
        }
        this.out.write(packetData, 0, packetData.length);
        this.out.flush();
        ++this.writtenPackets;
    }

    public long getNrOfWrittenPackets() {
        return this.writtenPackets;
    }

    public boolean isFinished() {
        return this.finished;
    }

    private void trace(String format, Object ... args) {
        if (this.TRACE) {
            Trace.debug((String)format, (Object[])args);
        }
    }
}

