/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.io;

import com.sap.jvm.debugging.controller.impl.packets.ConditionalBreakpointFailurePacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.DetailFormattersListPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.DisassembledClassPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.ExpressionVariableTreePacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.HotCodeReplacementErrorPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.HoverExpressionTreePacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.LocalVariableTreePacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.LogicalStructuresListPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.ThreadListDeltaPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.ThreadListPacketImpl;
import com.sap.jvm.debugging.controller.impl.packets.VariableAssignmentFailurePacketImpl;
import com.sap.jvm.debugging.controller.packets.ConnectPacketImpl;
import com.sap.jvm.debugging.controller.packets.ConnectToPidPacketImpl;
import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.ExitVmPacketImpl;
import com.sap.jvm.debugging.controller.packets.HandleReturnValuesPacketImpl;
import com.sap.jvm.debugging.controller.packets.HotCodeReplacementPacketImpl;
import com.sap.jvm.debugging.controller.packets.RefreshPacketImpl;
import com.sap.jvm.debugging.controller.packets.RequestDisassemblyByNamePacketImpl;
import com.sap.jvm.debugging.controller.packets.RequestDisassemblyByThreadPacketImpl;
import com.sap.jvm.debugging.controller.packets.ResumeAllThreadsPacketImpl;
import com.sap.jvm.debugging.controller.packets.ResumeThreadPacketImpl;
import com.sap.jvm.debugging.controller.packets.ShutdownPacketImpl;
import com.sap.jvm.debugging.controller.packets.StartDebuggingPacketImpl;
import com.sap.jvm.debugging.controller.packets.StepThreadPacketImpl;
import com.sap.jvm.debugging.controller.packets.SuspendAllThreadsPacketImpl;
import com.sap.jvm.debugging.controller.packets.SuspendThreadPacketImpl;
import com.sap.jvm.debugging.controller.packets.ThreadListFilterPacketImpl;
import com.sap.jvm.debugging.controller.packets.ThreadListSelectPacketImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointListPacketImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.SkipAllBreakpointsPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.AddDetailFormattersPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.AddExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.AddHoverExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.AddLogicalStructuresPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ChangeExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.EvalExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableExpansionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableFilterPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSelectPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSetExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.ExpressionVariableSetPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.HoverExpressionExpansionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.HoverExpressionSelectPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableExpansionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableFilterPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSelectPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSetExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableSetPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.RemoveDetailFormattersPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.RemoveExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.RemoveHoverExpressionPacketImpl;
import com.sap.jvm.debugging.controller.packets.variables.RemoveLogicalStructuresPacketImpl;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;

public final class PacketReader
implements Runnable {
    private final DataInputStream in;
    private volatile boolean closed = false;
    private volatile boolean finished = false;
    private byte[] buffer = new byte[4096];
    private final BlockingQueue<DebuggingPacket> packetQueue;
    private final BlockingQueue<DebuggingPacket> journalQueue;
    private volatile long readPackets = 0L;
    private final long CONNECTION_LATENCY_MS = Long.getLong("com.sap.jvm.debugging.latency", 0L);
    private final Tracer tracer;
    private final Tracer fullTracer = Trace.get((String)"com.sap.jvm.debugging.controller.io.reader.full");
    private final Set<PacketReaderListener> listener = new HashSet<PacketReaderListener>();

    public PacketReader(InputStream is, BlockingQueue<DebuggingPacket> queue) {
        this(is, queue, null, null);
    }

    public PacketReader(InputStream is, BlockingQueue<DebuggingPacket> queue, BlockingQueue<DebuggingPacket> journal, Object context) {
        this.in = new DataInputStream(new BufferedInputStream(is));
        this.packetQueue = queue;
        this.journalQueue = journal;
        this.tracer = Trace.get((String)"com.sap.jvm.debugging.controller.io.reader", (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        IOException exception = null;
        try {
            while (!this.closed) {
                this.readNextPacket();
            }
        }
        catch (IOException e) {
            exception = e;
            this.stop();
            this.tracer.debug((Throwable)e, "Exception while reading packets");
        }
        finally {
            this.tracer.debug("Reader: Stopped.");
            this.finished = true;
            for (PacketReaderListener l : this.listener) {
                l.finished(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.tracer.debug("Reader: Stopping...");
        boolean closedByUs = false;
        PacketReader packetReader = this;
        synchronized (packetReader) {
            if (!this.closed) {
                this.closed = true;
                closedByUs = true;
            }
        }
        if (closedByUs) {
            try {
                this.in.close();
            }
            catch (IOException e1) {
                this.tracer.warn((Throwable)e1, "Exception while closing input stream of packet reader");
            }
        }
    }

    private void readNextPacket() throws IOException {
        this.tracer.debug("Reader: Waiting for new packet...");
        this.in.readFully(this.buffer, 0, 8);
        DataInputStream tmp = new DataInputStream(new ByteArrayInputStream(this.buffer, 0, 8));
        int type = tmp.readInt();
        int remainingSize = tmp.readInt() - 8;
        if (remainingSize < 0 || remainingSize > 0x6400000) {
            throw new IOException("Illegal packet size: " + remainingSize + " (type=" + type + ")");
        }
        if (remainingSize > this.buffer.length) {
            this.buffer = new byte[remainingSize];
        }
        this.in.readFully(this.buffer, 0, remainingSize);
        this.tracer.debug("Reader: Received packet %s (type=%d, size=%d).", new Object[]{DebuggingTag.safeConvertTo(type), type, remainingSize + 8});
        tmp = new DataInputStream(new ByteArrayInputStream(this.buffer, 0, remainingSize));
        DebuggingPacket packet = null;
        try {
            packet = this.readPacketData(type, tmp);
        }
        catch (RuntimeException e) {
            this.tracer.warn((Throwable)e, "Exception while reading packet content (type=%d, size=%d)", new Object[]{type, remainingSize});
        }
        if (this.CONNECTION_LATENCY_MS > 0L) {
            try {
                this.tracer.debug(() -> "Reader: Emulating " + this.CONNECTION_LATENCY_MS + " ms connection latency.");
                Thread.sleep(this.CONNECTION_LATENCY_MS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (packet != null) {
            this.tracer.debug("Reader: Adding packet to packet queue.");
            DebuggingPacket packetForTrace = packet;
            this.fullTracer.debug(() -> {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                packetForTrace.print(ps);
                ps.close();
                return baos.toString();
            });
            this.packetQueue.add(packet);
            if (this.journalQueue != null) {
                this.journalQueue.add(packet);
            }
        }
        ++this.readPackets;
    }

    private DebuggingPacket readPacketData(int type, DataInputStream dis) throws IOException {
        switch (type) {
            case 1: {
                return ThreadListPacketImpl.read(dis);
            }
            case 2: {
                return ConnectPacketImpl.read(dis);
            }
            case 3: {
                return SuspendAllThreadsPacketImpl.read(dis);
            }
            case 4: {
                return ResumeAllThreadsPacketImpl.read(dis);
            }
            case 5: {
                return SuspendThreadPacketImpl.read(dis);
            }
            case 6: {
                return ResumeThreadPacketImpl.read(dis);
            }
            case 7: {
                return ThreadListSelectPacketImpl.read(dis);
            }
            case 8: {
                return LocalVariableTreePacketImpl.read(dis);
            }
            case 9: {
                return LocalVariableExpansionPacketImpl.read(dis);
            }
            case 10: {
                return BreakpointListPacketImpl.read(dis);
            }
            case 11: {
                return LocalVariableFilterPacketImpl.read(dis);
            }
            case 12: {
                return StepThreadPacketImpl.read(dis);
            }
            case 13: {
                return LocalVariableSelectPacketImpl.read(dis);
            }
            case 14: {
                return LocalVariableSetPacketImpl.read(dis);
            }
            case 15: {
                return ExpressionVariableTreePacketImpl.read(dis);
            }
            case 16: {
                return ExpressionVariableExpansionPacketImpl.read(dis);
            }
            case 17: {
                return ExpressionVariableFilterPacketImpl.read(dis);
            }
            case 18: {
                return ExpressionVariableSelectPacketImpl.read(dis);
            }
            case 19: {
                return ExpressionVariableSetPacketImpl.read(dis);
            }
            case 20: {
                return AddExpressionPacketImpl.read(dis);
            }
            case 21: {
                return ChangeExpressionPacketImpl.read(dis);
            }
            case 22: {
                return RemoveExpressionPacketImpl.read(dis);
            }
            case 23: {
                return LocalVariableSetExpressionPacketImpl.read(dis);
            }
            case 24: {
                return ExpressionVariableSetExpressionPacketImpl.read(dis);
            }
            case 25: {
                return VariableAssignmentFailurePacketImpl.read(dis);
            }
            case 26: {
                return ConditionalBreakpointFailurePacketImpl.read(dis);
            }
            case 27: {
                return HotCodeReplacementPacketImpl.read(dis);
            }
            case 28: {
                return HotCodeReplacementErrorPacketImpl.read(dis);
            }
            case 29: {
                return ShutdownPacketImpl.read(dis);
            }
            case 30: {
                return AddDetailFormattersPacketImpl.read(dis);
            }
            case 31: {
                return RemoveDetailFormattersPacketImpl.read(dis);
            }
            case 32: {
                return DetailFormattersListPacketImpl.read(dis);
            }
            case 33: {
                return AddLogicalStructuresPacketImpl.read(dis);
            }
            case 34: {
                return RemoveLogicalStructuresPacketImpl.read(dis);
            }
            case 35: {
                return LogicalStructuresListPacketImpl.read(dis);
            }
            case 36: {
                return RefreshPacketImpl.read(dis);
            }
            case 37: {
                return RequestDisassemblyByThreadPacketImpl.read(dis);
            }
            case 38: {
                return RequestDisassemblyByNamePacketImpl.read(dis);
            }
            case 39: {
                return DisassembledClassPacketImpl.read(dis);
            }
            case 40: {
                return ExitVmPacketImpl.read(dis);
            }
            case 41: {
                return AddHoverExpressionPacketImpl.read(dis);
            }
            case 42: {
                return RemoveHoverExpressionPacketImpl.read(dis);
            }
            case 43: {
                return HoverExpressionSelectPacketImpl.read(dis);
            }
            case 44: {
                return HoverExpressionExpansionPacketImpl.read(dis);
            }
            case 45: {
                return HoverExpressionTreePacketImpl.read(dis);
            }
            case 46: {
                return ThreadListFilterPacketImpl.read(dis);
            }
            case 47: {
                return EvalExpressionPacketImpl.read(dis);
            }
            case 48: {
                return SkipAllBreakpointsPacketImpl.read(dis);
            }
            case 49: {
                return StartDebuggingPacketImpl.read(dis);
            }
            case 50: {
                return ThreadListDeltaPacketImpl.read(dis);
            }
            case 51: {
                return ConnectToPidPacketImpl.read(dis);
            }
            case 52: {
                return HandleReturnValuesPacketImpl.read(dis);
            }
        }
        return null;
    }

    public long getNrOfReadPackets() {
        return this.readPackets;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void addListener(PacketReaderListener l) {
        this.listener.add(l);
    }

    public void removeListener(PacketReaderListener l) {
        this.listener.remove(l);
    }

    public static interface PacketReaderListener {
        public void finished(IOException var1);
    }
}

