/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.io;

import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public final class PacketWriter
implements Runnable {
    public static final long POLLING_PERIOD_MS = 500L;
    private final DataOutputStream out;
    private volatile boolean closed = false;
    private volatile boolean finished = false;
    private final BlockingQueue<DebuggingPacket> packetQueue;
    private final BlockingQueue<DebuggingPacket> journalQueue;
    private volatile long writtenPackets = 0L;
    private final long CONNECTION_LATENCY_MS = Long.getLong("com.sap.jvm.debugging.latency", 0L);
    private final Tracer tracer;
    private final Tracer fullTracer = Trace.get((String)"com.sap.jvm.debugging.controller.io.writer.full");

    public PacketWriter(OutputStream os, BlockingQueue<DebuggingPacket> queue) {
        this(os, queue, null, null);
    }

    public PacketWriter(OutputStream os, BlockingQueue<DebuggingPacket> queue, BlockingQueue<DebuggingPacket> journal, Object context) {
        this.out = new DataOutputStream(new BufferedOutputStream(os));
        this.packetQueue = queue;
        this.journalQueue = journal;
        this.tracer = Trace.get((String)"com.sap.jvm.debugging.controller.io.writer", (Object)context);
    }

    @Override
    public void run() {
        block11: {
            try {
                this.tracer.debug("Writer: Waiting for new packet...");
                while (!this.closed) {
                    try {
                        DebuggingPacket packet = this.packetQueue.poll(500L, TimeUnit.MILLISECONDS);
                        if (packet == null) continue;
                        this.writePacket(packet);
                        if (this.journalQueue != null) {
                            this.journalQueue.add(packet);
                        }
                        this.tracer.debug("Writer: Waiting for new packet...");
                    }
                    catch (InterruptedException packet) {}
                }
            }
            catch (IOException e) {
                if (this.closed) break block11;
                this.closed = true;
                try {
                    this.out.close();
                }
                catch (IOException e1) {
                    this.tracer.warn((Throwable)e1, "Exception while closing output stream of packet writer");
                }
                this.tracer.warn((Throwable)e, "Exception while writing packets");
            }
            finally {
                this.tracer.debug("Writer: Stopped.");
                this.finished = true;
            }
        }
    }

    public void stop() throws IOException {
        this.tracer.debug("Writer: Stopping...");
        this.closed = true;
        this.out.close();
    }

    private void writePacket(DebuggingPacket packet) throws IOException {
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        packet.write(new DataOutputStream(bufferStream));
        byte[] data = bufferStream.toByteArray();
        int type = packet.getType().get();
        int size = data.length + 8;
        bufferStream = new ByteArrayOutputStream();
        DataOutputStream tmp = new DataOutputStream(bufferStream);
        tmp.writeInt(type);
        tmp.writeInt(size);
        byte[] header = bufferStream.toByteArray();
        assert (header.length == 8);
        byte[] packetData = new byte[data.length + header.length];
        System.arraycopy(header, 0, packetData, 0, header.length);
        System.arraycopy(data, 0, packetData, header.length, data.length);
        if (this.CONNECTION_LATENCY_MS > 0L) {
            try {
                this.tracer.debug(() -> "Writer: Emulating " + this.CONNECTION_LATENCY_MS + " ms connection latency.");
                Thread.sleep(this.CONNECTION_LATENCY_MS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.tracer.debug("Writer: Sending packet %s (type=%d, size=%d)...", new Object[]{packet.getType(), packet.getType().get(), packetData.length});
        this.fullTracer.debug(() -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            packet.print(ps);
            ps.close();
            return baos.toString();
        });
        this.out.write(packetData, 0, packetData.length);
        this.out.flush();
        ++this.writtenPackets;
    }

    public long getNrOfWrittenPackets() {
        return this.writtenPackets;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

