/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.ConnectPacket;
import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ConnectPacketImpl
implements ConnectPacket {
    private final String hostname;
    private final int port;

    public static ConnectPacketImpl read(DataInputStream in) throws IOException {
        return new ConnectPacketImpl(in);
    }

    private ConnectPacketImpl(DataInputStream in) throws IOException {
        this.hostname = in.readUTF();
        this.port = in.readInt();
    }

    public ConnectPacketImpl(String address, int port) {
        this.hostname = address;
        this.port = port;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.CONNECT_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.hostname);
        out.writeInt(this.port);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Host name                     : " + this.hostname);
        stream.println("    Port                          : " + this.port);
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        int result = 27;
        result ^= this.hostname == null ? 0 : this.hostname.hashCode();
        return result ^= this.port;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectPacketImpl other = (ConnectPacketImpl)obj;
        if (this.hostname == null) {
            return other.hostname == null && this.port == other.port;
        }
        return this.port == other.port && this.hostname.equals(other.hostname);
    }
}

