/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.ConnectToPidPacket;
import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ConnectToPidPacketImpl
implements ConnectToPidPacket {
    private final int pid;

    public static ConnectToPidPacketImpl read(DataInputStream in) throws IOException {
        return new ConnectToPidPacketImpl(in);
    }

    private ConnectToPidPacketImpl(DataInputStream in) throws IOException {
        this.pid = in.readInt();
    }

    public ConnectToPidPacketImpl(int pid) {
        this.pid = pid;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.CONNECT_TO_PID_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.pid);
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    PID                           : " + this.pid);
    }

    public int hashCode() {
        return this.pid;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectToPidPacketImpl other = (ConnectToPidPacketImpl)obj;
        return this.pid == other.pid;
    }
}

