/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.impl.packets.DisassembledClassPacketImpl;
import com.sap.jvm.debugging.controller.packets.DisassembledClassPacket;
import com.sap.jvm.tracing.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class DisassembledClassPacketFactory {
    public static String serializeToString(DisassembledClassPacket packet) {
        if (packet != null) {
            try {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(byteOut);
                packet.write(out);
                return DisassembledClassPacketFactory.toHex(byteOut.toByteArray());
            }
            catch (IOException e) {
                Trace.error((Throwable)e);
            }
        }
        return null;
    }

    public static DisassembledClassPacket deserealizeFromString(String data) {
        if (data != null) {
            byte[] bytes = DisassembledClassPacketFactory.hexStringToByteArray(data);
            try {
                return DisassembledClassPacketImpl.read(new DataInputStream(new ByteArrayInputStream(bytes)));
            }
            catch (IOException e) {
                Trace.error((Throwable)e);
            }
        }
        return null;
    }

    private static String toHex(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
        }
        return strbuf.toString();
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

