/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.ExitVmPacket;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class ExitVmPacketImpl
implements ExitVmPacket {
    private final int exitCode;

    public ExitVmPacketImpl(int exitCode) {
        this.exitCode = exitCode;
    }

    public static ExitVmPacketImpl read(DataInputStream in) throws IOException {
        return new ExitVmPacketImpl(in);
    }

    private ExitVmPacketImpl(DataInputStream in) throws IOException {
        this.exitCode = in.readInt();
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.EXIT_VM_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.exitCode);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    exit code : " + this.exitCode);
    }

    public int hashCode() {
        return this.exitCode;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExitVmPacketImpl other = (ExitVmPacketImpl)obj;
        return this.exitCode == other.exitCode;
    }
}

