/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.HotCodeReplacementPacket;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;

public final class HotCodeReplacementPacketImpl
implements HotCodeReplacementPacket {
    private final String[] names;
    private final byte[][] classData;

    public static HotCodeReplacementPacketImpl read(DataInputStream in) throws IOException {
        return new HotCodeReplacementPacketImpl(in);
    }

    private HotCodeReplacementPacketImpl(DataInputStream in) throws IOException {
        int size = in.readInt();
        this.names = new String[size];
        this.classData = new byte[size][];
        for (int i = 0; i < size; ++i) {
            this.names[i] = in.readUTF();
            this.classData[i] = new byte[in.readInt()];
            in.readFully(this.classData[i]);
        }
    }

    public HotCodeReplacementPacketImpl(Map<String, byte[]> classMapping) {
        this.names = new String[classMapping.size()];
        this.classData = new byte[classMapping.size()][];
        int i = 0;
        for (Map.Entry<String, byte[]> entry : classMapping.entrySet()) {
            this.names[i] = entry.getKey();
            this.classData[i] = (byte[])entry.getValue().clone();
            ++i;
        }
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.HOT_CODE_REPLACEMENT_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        assert (this.names.length == this.classData.length);
        out.writeInt(this.names.length);
        for (int i = 0; i < this.names.length; ++i) {
            out.writeUTF(this.names[i]);
            out.writeInt(this.classData[i].length);
            out.write(this.classData[i]);
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        for (int i = 0; i < this.names.length; ++i) {
            stream.println("    " + (i + 1) + ". Class name                    : " + this.names[i]);
            stream.println("    " + (i + 1) + ". Class bytes                   : " + this.classData[i].length);
        }
    }

    @Override
    public int getNumberOfReplacements() {
        assert (this.names.length == this.classData.length);
        return this.names.length;
    }

    @Override
    public String getName(int index) {
        return this.names[index];
    }

    @Override
    public byte[] getBytes(int index) {
        return (byte[])this.classData[index].clone();
    }

    public int hashCode() {
        return Arrays.hashCode(this.names) ^ Arrays.deepHashCode((Object[])this.classData);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HotCodeReplacementPacketImpl other = (HotCodeReplacementPacketImpl)obj;
        return Arrays.equals(this.names, other.names) && Arrays.deepEquals((Object[])this.classData, (Object[])other.classData);
    }
}

