/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.RequestDisassemblyByNamePacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class RequestDisassemblyByNamePacketImpl
implements RequestDisassemblyByNamePacket {
    private final String className;
    private final long classObjectId;
    private final boolean includeDisassembly;
    private final boolean includeDecompiledCode;

    public static RequestDisassemblyByNamePacketImpl read(DataInputStream in) throws IOException {
        return new RequestDisassemblyByNamePacketImpl(in);
    }

    private RequestDisassemblyByNamePacketImpl(DataInputStream in) throws IOException {
        this.className = in.readUTF();
        this.classObjectId = in.readLong();
        boolean disassembly = true;
        boolean decompilation = true;
        if (in.available() > 0) {
            disassembly = in.readBoolean();
        }
        if (in.available() > 0) {
            decompilation = in.readBoolean();
        }
        this.includeDisassembly = disassembly;
        this.includeDecompiledCode = decompilation;
    }

    public RequestDisassemblyByNamePacketImpl(String className, long classObjectId, boolean includeDisassembly, boolean includeDecompiledCode) {
        this.className = className;
        this.classObjectId = classObjectId;
        this.includeDisassembly = includeDisassembly;
        this.includeDecompiledCode = includeDecompiledCode;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.REQUEST_DISASSEMBLY_BY_NAME_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.className);
        out.writeLong(this.classObjectId);
        out.writeBoolean(this.includeDisassembly);
        out.writeBoolean(this.includeDecompiledCode);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Class name                    : " + this.className);
        stream.println("    Class object identifier       : " + this.classObjectId);
        stream.println("    Include disassembly           : " + (this.includeDisassembly ? "yes" : "no"));
        stream.println("    Include decompiled code       : " + (this.includeDecompiledCode ? "yes" : "no"));
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public long getClassObjectId() {
        return this.classObjectId;
    }

    @Override
    public boolean includeDisassembly() {
        return this.includeDisassembly;
    }

    @Override
    public boolean includeDecompiledCode() {
        return this.includeDecompiledCode;
    }

    public int hashCode() {
        int result = 29;
        result ^= this.className == null ? 0 : this.className.hashCode();
        result ^= (int)(this.classObjectId >> 32 ^ this.classObjectId);
        result ^= this.includeDisassembly ? 2 : 0;
        return result ^= this.includeDecompiledCode ? 4 : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RequestDisassemblyByNamePacketImpl other = (RequestDisassemblyByNamePacketImpl)obj;
        if (this.includeDisassembly != other.includeDisassembly || this.includeDecompiledCode != other.includeDecompiledCode) {
            return false;
        }
        if (this.className == null) {
            return other.className == null && this.classObjectId == other.classObjectId;
        }
        return this.classObjectId == other.classObjectId && this.className.equals(other.className);
    }
}

