/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.RequestDisassemblyByThreadPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class RequestDisassemblyByThreadPacketImpl
implements RequestDisassemblyByThreadPacket {
    private final long threadId;
    private final int frameIndex;
    private final boolean includeDisassembly;
    private final boolean includeDecompiledCode;

    public static RequestDisassemblyByThreadPacketImpl read(DataInputStream in) throws IOException {
        return new RequestDisassemblyByThreadPacketImpl(in);
    }

    private RequestDisassemblyByThreadPacketImpl(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
        this.frameIndex = in.readInt();
        boolean disassembly = true;
        boolean decompilation = true;
        if (in.available() > 0) {
            disassembly = in.readBoolean();
        }
        if (in.available() > 0) {
            decompilation = in.readBoolean();
        }
        this.includeDisassembly = disassembly;
        this.includeDecompiledCode = decompilation;
    }

    public RequestDisassemblyByThreadPacketImpl(long threadId, int frameIndex, boolean includeDisassembly, boolean includeDecompiledCode) {
        this.threadId = threadId;
        this.frameIndex = frameIndex;
        this.includeDisassembly = includeDisassembly;
        this.includeDecompiledCode = includeDecompiledCode;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.REQUEST_DISASSEMBLY_BY_THREAD_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
        out.writeInt(this.frameIndex);
        out.writeBoolean(this.includeDisassembly);
        out.writeBoolean(this.includeDecompiledCode);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
        stream.println("    Frame index                   : " + this.frameIndex);
        stream.println("    Include disassembly           : " + (this.includeDisassembly ? "yes" : "no"));
        stream.println("    Include decompiled code       : " + (this.includeDecompiledCode ? "yes" : "no"));
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public boolean includeDisassembly() {
        return this.includeDisassembly;
    }

    @Override
    public boolean includeDecompiledCode() {
        return this.includeDecompiledCode;
    }

    public int hashCode() {
        return (int)(this.threadId >> 32 ^ this.threadId) ^ this.frameIndex ^ (this.includeDisassembly ? 2 : 0) ^ (this.includeDecompiledCode ? 4 : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RequestDisassemblyByThreadPacketImpl other = (RequestDisassemblyByThreadPacketImpl)obj;
        return this.threadId == other.threadId && this.frameIndex == other.frameIndex && this.includeDisassembly == other.includeDisassembly && this.includeDecompiledCode == other.includeDecompiledCode;
    }
}

