/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public interface StepThreadPacket
extends DebuggingPacket {
    public long getThreadId();

    public StepPolicy getPolicy();

    public static enum StepPolicy {
        STEP_MIN_INTO,
        STEP_INTO,
        STEP_OVER,
        STEP_OUT,
        STEP_MIN_OVER;


        public static StepPolicy read(DataInputStream in) throws IOException {
            byte policy = in.readByte();
            switch (policy) {
                case 0: {
                    return STEP_MIN_INTO;
                }
                case 1: {
                    return STEP_INTO;
                }
                case 2: {
                    return STEP_OVER;
                }
                case 3: {
                    return STEP_OUT;
                }
                case 4: {
                    return STEP_MIN_OVER;
                }
            }
            throw new IllegalStateException("Unknown step policy: " + policy);
        }

        public void write(DataOutputStream out) throws IOException {
            int policy;
            switch (this) {
                case STEP_MIN_INTO: {
                    policy = 0;
                    break;
                }
                case STEP_INTO: {
                    policy = 1;
                    break;
                }
                case STEP_OVER: {
                    policy = 2;
                    break;
                }
                case STEP_OUT: {
                    policy = 3;
                    break;
                }
                case STEP_MIN_OVER: {
                    policy = 4;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown step policy: " + (Object)((Object)this));
                }
            }
            out.writeByte(policy);
        }
    }
}

