/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.StepThreadPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class StepThreadPacketImpl
implements StepThreadPacket {
    private final long threadId;
    private final StepThreadPacket.StepPolicy policy;

    public static StepThreadPacketImpl read(DataInputStream in) throws IOException {
        return new StepThreadPacketImpl(in);
    }

    private StepThreadPacketImpl(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
        this.policy = StepThreadPacket.StepPolicy.read(in);
    }

    public StepThreadPacketImpl(long id, StepThreadPacket.StepPolicy policy) {
        this.threadId = id;
        this.policy = policy;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.STEP_THREAD_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
        this.policy.write(out);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
        stream.println("    Step policy                   : " + (Object)((Object)this.policy));
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public StepThreadPacket.StepPolicy getPolicy() {
        return this.policy;
    }

    public int hashCode() {
        return 0x35 ^ (int)(this.threadId >> 32 ^ this.threadId ^ (long)this.policy.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StepThreadPacketImpl other = (StepThreadPacketImpl)obj;
        return this.threadId == other.threadId && this.policy == other.policy;
    }
}

