/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.SuspendThreadPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class SuspendThreadPacketImpl
implements SuspendThreadPacket {
    private final long threadId;

    public static SuspendThreadPacketImpl read(DataInputStream in) throws IOException {
        return new SuspendThreadPacketImpl(in);
    }

    private SuspendThreadPacketImpl(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
    }

    public SuspendThreadPacketImpl(long id) {
        this.threadId = id;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.SUSPEND_THREAD_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    public int hashCode() {
        return 0x2B ^ (int)(this.threadId >> 32 ^ this.threadId);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SuspendThreadPacketImpl other = (SuspendThreadPacketImpl)obj;
        return this.threadId == other.threadId;
    }
}

