/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.ThreadListFilterPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ThreadListFilterPacketImpl
implements ThreadListFilterPacket {
    private final boolean showRunningSystemThreads;
    private final boolean sendOnlyDeltas;

    public static ThreadListFilterPacketImpl read(DataInputStream in) throws IOException {
        return new ThreadListFilterPacketImpl(in);
    }

    private ThreadListFilterPacketImpl(DataInputStream in) throws IOException {
        this.showRunningSystemThreads = in.readBoolean();
        this.sendOnlyDeltas = in.available() > 0 ? in.readBoolean() : false;
    }

    public ThreadListFilterPacketImpl(boolean showRunningSystemThreads, boolean sendOnlyDeltas) {
        this.showRunningSystemThreads = showRunningSystemThreads;
        this.sendOnlyDeltas = sendOnlyDeltas;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.THREAD_LIST_FILTER_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeBoolean(this.showRunningSystemThreads);
        out.writeBoolean(this.sendOnlyDeltas);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Show running system threads   : " + (this.showRunningSystemThreads ? "yes" : "no"));
        stream.println("    Send only deltas of changes   : " + (this.sendOnlyDeltas ? "yes" : "no"));
    }

    @Override
    public boolean showRunningSystemThreads() {
        return this.showRunningSystemThreads;
    }

    @Override
    public boolean sendOnlyDeltas() {
        return this.sendOnlyDeltas;
    }

    public int hashCode() {
        return (this.showRunningSystemThreads ? 1 : 0) ^ (this.sendOnlyDeltas ? 2 : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadListFilterPacketImpl other = (ThreadListFilterPacketImpl)obj;
        return this.showRunningSystemThreads == other.showRunningSystemThreads && this.sendOnlyDeltas == other.sendOnlyDeltas;
    }
}

