/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.ThreadListSelectPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ThreadListSelectPacketImpl
implements ThreadListSelectPacket {
    private final long threadId;
    private final int frameIndex;

    public static ThreadListSelectPacketImpl read(DataInputStream in) throws IOException {
        return new ThreadListSelectPacketImpl(in);
    }

    private ThreadListSelectPacketImpl(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
        this.frameIndex = in.readInt();
    }

    public ThreadListSelectPacketImpl(long threadId, int frameIndex) {
        this.threadId = threadId;
        this.frameIndex = frameIndex;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.THREAD_LIST_SELECT_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
        out.writeInt(this.frameIndex);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
        stream.println("    Stack frame index             : " + this.frameIndex);
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getFrameIndex() {
        return this.frameIndex;
    }

    public int hashCode() {
        return (int)(this.threadId >> 32 ^ this.threadId) ^ this.frameIndex;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadListSelectPacketImpl other = (ThreadListSelectPacketImpl)obj;
        return this.threadId == other.threadId && this.frameIndex == other.frameIndex;
    }
}

