/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.breakpoints;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.breakpoints.BreakpointLocation;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public abstract class AbstractBreakpointSpecification
implements BreakpointSpecification,
Cloneable {
    protected static final long[] EMPTY_THREAD_LIST = new long[0];
    protected static final BreakpointLocation[] EMPTY_LOCATIONS = new BreakpointLocation[0];
    private final String name;
    private boolean isEnabled = true;
    private boolean suspendsThread = true;
    private int hitCount = -1;
    private boolean isBooleanCondition;
    private String condition = null;
    private long threadToBeIgnored = 0L;
    private long[] ignoredThreads = EMPTY_THREAD_LIST;
    private BreakpointLocation[] ignoredLocations = EMPTY_LOCATIONS;
    private BreakpointLocation[] includedLocations = EMPTY_LOCATIONS;

    protected AbstractBreakpointSpecification(String name) {
        this.name = name;
    }

    protected AbstractBreakpointSpecification(DataInputStream in) throws IOException {
        this.name = in.readUTF();
        this.isEnabled = in.readBoolean();
        this.suspendsThread = in.readBoolean();
    }

    protected void readOptional(DataInputStream in) throws IOException {
        int i;
        this.hitCount = in.readInt();
        if (in.readBoolean()) {
            this.isBooleanCondition = in.readBoolean();
            this.condition = in.readUTF();
        }
        this.threadToBeIgnored = in.readLong();
        if (in.readBoolean()) {
            this.ignoredThreads = new long[in.readInt()];
            for (i = 0; i < this.ignoredThreads.length; ++i) {
                this.ignoredThreads[i] = in.readLong();
            }
        }
        if (in.readBoolean()) {
            this.ignoredLocations = new BreakpointLocation[in.readInt()];
            for (i = 0; i < this.ignoredLocations.length; ++i) {
                this.ignoredLocations[i] = new BreakpointLocation(in);
            }
        }
        if (in.readBoolean()) {
            this.includedLocations = new BreakpointLocation[in.readInt()];
            for (i = 0; i < this.includedLocations.length; ++i) {
                this.includedLocations[i] = new BreakpointLocation(in);
            }
        }
    }

    protected void writeMandatory(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeBoolean(this.isEnabled);
        out.writeBoolean(this.suspendsThread);
    }

    protected void writeOptional(DataOutputStream out) throws IOException {
        int i;
        out.writeInt(this.hitCount);
        out.writeBoolean(this.hasCondition());
        if (this.hasCondition()) {
            out.writeBoolean(this.isBooleanCondition);
            out.writeUTF(this.condition);
        }
        out.writeLong(this.threadToBeIgnored);
        out.writeBoolean(this.ignoredThreads.length > 0);
        if (this.ignoredThreads.length > 0) {
            out.writeInt(this.ignoredThreads.length);
            for (i = 0; i < this.ignoredThreads.length; ++i) {
                out.writeLong(this.ignoredThreads[i]);
            }
        }
        out.writeBoolean(this.ignoredLocations.length > 0);
        if (this.ignoredLocations.length > 0) {
            out.writeInt(this.ignoredLocations.length);
            for (i = 0; i < this.ignoredLocations.length; ++i) {
                this.ignoredLocations[i].write(out);
            }
        }
        out.writeBoolean(this.includedLocations.length > 0);
        if (this.includedLocations.length > 0) {
            out.writeInt(this.includedLocations.length);
            for (i = 0; i < this.includedLocations.length; ++i) {
                this.includedLocations[i].write(out);
            }
        }
    }

    @Override
    public void print(PrintStream stream) {
        int i;
        stream.println("        Breakpoint name           : " + this.name);
        stream.println("        Breakpoint type           : " + (Object)((Object)this.getType()));
        stream.println("        Enabled                   : " + (this.isEnabled ? "yes" : "no"));
        stream.println("        Hit count                 : " + (this.hitCount > 0 ? Integer.valueOf(this.hitCount) : "none"));
        stream.println("        Boolean condition         : " + (this.isBooleanCondition() ? this.condition : "none"));
        stream.println("        Value change condition    : " + (this.isValueChangeCondition() ? this.condition : "none"));
        stream.println("        Suspend type              : " + (this.suspendsThread ? "thread" : "vm"));
        if (this.threadToBeIgnored != 0L) {
            stream.println("        Thread to be ignored      : " + this.threadToBeIgnored);
        }
        for (i = 0; i < this.ignoredThreads.length; ++i) {
            stream.println("        " + (i + 1) + ". Ignored thread         : " + this.ignoredThreads[i]);
        }
        for (i = 0; i < this.ignoredLocations.length; ++i) {
            stream.println("        " + (i + 1) + ". Ignored location       : " + this.ignoredLocations[i]);
        }
        for (i = 0; i < this.includedLocations.length; ++i) {
            stream.println("        " + (i + 1) + ". Included location      : " + this.includedLocations[i]);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public BreakpointSpecification setEnabled(boolean enabled) {
        AbstractBreakpointSpecification clone = this.safeClone();
        clone.isEnabled = enabled;
        return clone;
    }

    @Override
    public boolean isSuspendThread() {
        return this.suspendsThread;
    }

    @Override
    public BreakpointSpecification setSuspendThread(boolean suspendThread) {
        AbstractBreakpointSpecification clone = this.safeClone();
        clone.suspendsThread = suspendThread;
        return clone;
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    public BreakpointSpecification setHitCount(int hitCount) {
        AbstractBreakpointSpecification clone = this.safeClone();
        clone.hitCount = hitCount > 1 ? hitCount : -1;
        return clone;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null;
    }

    @Override
    public boolean isBooleanCondition() {
        return this.hasCondition() && this.isBooleanCondition;
    }

    @Override
    public boolean isValueChangeCondition() {
        return this.hasCondition() && !this.isBooleanCondition;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public BreakpointSpecification setCondition(String condition, boolean isBoolean) {
        AbstractBreakpointSpecification clone = this.safeClone();
        clone.isBooleanCondition = isBoolean;
        clone.condition = condition;
        return clone;
    }

    @Override
    public long getThreadToBeIgnored() {
        return this.threadToBeIgnored;
    }

    @Override
    public BreakpointSpecification setThreadToBeIgnored(long threadId) {
        AbstractBreakpointSpecification clone = this.safeClone();
        clone.threadToBeIgnored = threadId;
        return clone;
    }

    @Override
    public long[] getIgnoredThreads() {
        return this.ignoredThreads.length > 0 ? (long[])this.ignoredThreads.clone() : this.ignoredThreads;
    }

    @Override
    public BreakpointSpecification setIgnoredThreads(long[] threadIds) {
        AbstractBreakpointSpecification clone = this.safeClone();
        clone.ignoredThreads = threadIds == null || threadIds.length == 0 ? EMPTY_THREAD_LIST : (long[])threadIds.clone();
        return clone;
    }

    @Override
    public BreakpointLocation[] getIgnoredLocations() {
        return this.ignoredLocations.length > 0 ? (BreakpointLocation[])this.ignoredLocations.clone() : this.ignoredLocations;
    }

    @Override
    public BreakpointSpecification setIgnoredLocations(BreakpointLocation[] locations) {
        AbstractBreakpointSpecification clone = this.safeClone();
        clone.ignoredLocations = locations == null || locations.length == 0 ? EMPTY_LOCATIONS : (BreakpointLocation[])locations.clone();
        return clone;
    }

    @Override
    public BreakpointLocation[] getIncludedLocations() {
        return this.includedLocations.length > 0 ? (BreakpointLocation[])this.includedLocations.clone() : this.includedLocations;
    }

    @Override
    public BreakpointSpecification setIncludedLocations(BreakpointLocation[] locations) {
        AbstractBreakpointSpecification clone = this.safeClone();
        clone.includedLocations = locations == null || locations.length == 0 ? EMPTY_LOCATIONS : (BreakpointLocation[])locations.clone();
        return clone;
    }

    @Override
    public final Breakpoint createBreakpoint(Debugger debugger) {
        Breakpoint breakpoint = this.createBreakpointImpl(debugger);
        breakpoint.setHitCount(this.hitCount);
        if (this.hasCondition()) {
            if (this.isBooleanCondition()) {
                breakpoint.setBooleanCondition(this.condition);
            } else {
                breakpoint.setValueChangeCondition(this.condition);
            }
        }
        if (this.ignoredThreads.length > 0) {
            breakpoint.setIgnoredThreads(this.getIgnoredThreads());
        }
        if (this.ignoredLocations.length > 0) {
            breakpoint.setIgnoredLocations(this.getIgnoredLocations());
        }
        if (this.includedLocations.length > 0) {
            breakpoint.setIncludedLocations(this.getIncludedLocations());
        }
        breakpoint.setSuspendsThread(this.suspendsThread);
        breakpoint.setEnabled(this.isEnabled);
        return breakpoint;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.isEnabled ? 1231 : 1237);
        result = 31 * result + (this.suspendsThread ? 1231 : 1237);
        result = 31 * result + this.hitCount;
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.condition == null ? 0 : (this.isBooleanCondition ? 1231 : 1237));
        result = 31 * result + (int)(this.threadToBeIgnored ^ this.threadToBeIgnored >>> 32);
        result = 31 * result + Arrays.hashCode(this.ignoredThreads);
        result = 31 * result + Arrays.hashCode(this.ignoredLocations);
        result = 31 * result + Arrays.hashCode(this.includedLocations);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBreakpointSpecification other = (AbstractBreakpointSpecification)obj;
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition) || this.isBooleanCondition != other.isBooleanCondition) {
            return false;
        }
        return this.name.equals(other.name) && this.isEnabled == other.isEnabled && this.suspendsThread == other.suspendsThread && this.hitCount == other.hitCount && this.threadToBeIgnored == other.threadToBeIgnored && Arrays.equals(this.ignoredThreads, other.ignoredThreads) && Arrays.equals(this.ignoredLocations, other.ignoredLocations) && Arrays.equals(this.includedLocations, other.includedLocations);
    }

    @Override
    public boolean equalNonDefaultAttributes(BreakpointSpecification other) {
        return other != null && this.getClass() == other.getClass();
    }

    protected abstract Breakpoint createBreakpointImpl(Debugger var1);

    private AbstractBreakpointSpecification safeClone() {
        try {
            return (AbstractBreakpointSpecification)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

