/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.breakpoints;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.breakpoints.AbsoluteMethodLineBreakpointSpecificationImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointListPacket;
import com.sap.jvm.debugging.controller.packets.breakpoints.ExceptionBreakpointSpecificationImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.LineBreakpointSpecificationImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.MethodBciBreakpointSpecificationImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.MethodEntryBreakpointSpecificationImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.MethodExitBreakpointSpecificationImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.RelativeMethodLineBreakpointSpecificationImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.TypeLineBreakpointSpecificationImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.WatchPointSpecificationImpl;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class BreakpointListPacketImpl
implements BreakpointListPacket {
    private static Map<BreakpointType, Constructor<?>> constructors = new HashMap();
    private static Map<BreakpointType, Method> deserializer = new HashMap<BreakpointType, Method>();
    private final BreakpointSpecification[] breakpoints;

    public static BreakpointListPacketImpl read(DataInputStream in) throws IOException {
        return new BreakpointListPacketImpl(in);
    }

    private BreakpointListPacketImpl(DataInputStream in) throws IOException {
        DataInputStream input = new DataInputStream(new GZIPInputStream(in));
        int size = input.readInt();
        this.breakpoints = new BreakpointSpecification[size];
        for (int i = 0; i < size; ++i) {
            BreakpointType type = BreakpointType.read(input);
            Method readMethod = deserializer.get((Object)type);
            int specSize = input.readInt();
            byte[] data = new byte[specSize];
            input.readFully(data);
            DataInputStream tmpIn = new DataInputStream(new ByteArrayInputStream(data));
            try {
                this.breakpoints[i] = (BreakpointSpecification)readMethod.invoke(null, tmpIn);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw (IOException)new IOException().initCause(e);
            }
            tmpIn.close();
        }
    }

    public BreakpointListPacketImpl(BreakpointSpecification breakpoint) {
        this(new BreakpointSpecification[]{breakpoint});
    }

    public BreakpointListPacketImpl(BreakpointSpecification[] breakpoints) {
        this.breakpoints = (BreakpointSpecification[])breakpoints.clone();
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.BREAKPOINT_LIST_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        GZIPOutputStream zipOut = new GZIPOutputStream(out);
        DataOutputStream output = new DataOutputStream(zipOut);
        output.writeInt(this.breakpoints.length);
        for (int i = 0; i < this.breakpoints.length; ++i) {
            this.breakpoints[i].getType().write(output);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream tmpOut = new DataOutputStream(buffer);
            this.breakpoints[i].write(tmpOut);
            tmpOut.flush();
            tmpOut.close();
            byte[] data = buffer.toByteArray();
            output.writeInt(data.length);
            output.write(data);
        }
        zipOut.finish();
        output.flush();
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        for (int i = 0; i < this.breakpoints.length; ++i) {
            stream.println("    " + (i + 1) + ". Breakpoint");
            this.breakpoints[i].print(stream);
        }
    }

    @Override
    public int getBreakpointCount() {
        return this.breakpoints.length;
    }

    @Override
    public BreakpointSpecification getBreakpoint(int index) {
        return this.breakpoints[index];
    }

    @Override
    public BreakpointSpecification[] getBreakpoints() {
        return (BreakpointSpecification[])this.breakpoints.clone();
    }

    public int hashCode() {
        return Arrays.hashCode(this.breakpoints);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BreakpointListPacketImpl other = (BreakpointListPacketImpl)obj;
        return Arrays.equals(this.breakpoints, other.breakpoints);
    }

    public static Constructor<?> getConstructorForType(BreakpointType type) {
        return constructors.get((Object)type);
    }

    private static Method getReadMethod(Class<?> clazz) {
        try {
            return clazz.getDeclaredMethod("read", DataInputStream.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructor(String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        HashMap<BreakpointType, Class<TypeLineBreakpointSpecificationImpl>> classes = new HashMap<BreakpointType, Class<TypeLineBreakpointSpecificationImpl>>();
        classes.put(BreakpointType.METHOD_ENTRY, MethodEntryBreakpointSpecificationImpl.class);
        classes.put(BreakpointType.EXCEPTION, ExceptionBreakpointSpecificationImpl.class);
        classes.put(BreakpointType.ABSOLUTE_METHOD_LINE, AbsoluteMethodLineBreakpointSpecificationImpl.class);
        classes.put(BreakpointType.RELATIVE_METHOD_LINE, RelativeMethodLineBreakpointSpecificationImpl.class);
        classes.put(BreakpointType.WATCH_POINT, WatchPointSpecificationImpl.class);
        classes.put(BreakpointType.LINE, LineBreakpointSpecificationImpl.class);
        classes.put(BreakpointType.METHOD_BYTE_CODE_INDEX, MethodBciBreakpointSpecificationImpl.class);
        classes.put(BreakpointType.METHOD_EXIT, MethodExitBreakpointSpecificationImpl.class);
        classes.put(BreakpointType.TYPE_LINE, TypeLineBreakpointSpecificationImpl.class);
        for (Map.Entry entry : classes.entrySet()) {
            deserializer.put((BreakpointType)((Object)entry.getKey()), BreakpointListPacketImpl.getReadMethod((Class)entry.getValue()));
            constructors.put((BreakpointType)((Object)entry.getKey()), BreakpointListPacketImpl.getConstructor((Class)entry.getValue()));
        }
    }
}

