/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.breakpoints;

import com.sap.jvm.debugging.breakpoints.BreakpointLocation;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointListPacketImpl;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BreakpointParser {
    private static final String NAME_ID = "name";
    private static final String TYPE_ID = "type";
    private static final String CONDITION_ID = "condition";
    private static final String CONDITION_TYPE_ID = "booleancondition";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String PAIR_SEPARATOR = ",";
    private static final String ESCAPED_PAIR_SEPARATOR = "\\,";
    private static final String SERIALIZE_ESCAPED_PAIR_SEPARATOR = Matcher.quoteReplacement("\\,");
    private static final String DESERIALIZE_ESCAPED_PAIR_SEPARATOR = Pattern.quote("\\,");
    private static final Map<BreakpointType, Map<String, Method>> gettersPerType = new HashMap<BreakpointType, Map<String, Method>>();
    private static final Map<BreakpointType, Map<String, Method>> settersPerType = new HashMap<BreakpointType, Map<String, Method>>();

    public static String serialize(BreakpointSpecification breakpoint) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(BreakpointParser.serializePair(TYPE_ID, (Object)breakpoint.getType()));
        buffer.append(PAIR_SEPARATOR);
        buffer.append(BreakpointParser.serializePair(NAME_ID, breakpoint.getName()));
        buffer.append(PAIR_SEPARATOR);
        Map<String, Method> attributes = gettersPerType.get((Object)breakpoint.getType());
        Method getCondition = attributes.get(CONDITION_ID);
        Method getConditionType = attributes.get(CONDITION_TYPE_ID);
        for (Map.Entry<String, Method> entry : attributes.entrySet()) {
            if (entry.getValue() == getConditionType) continue;
            if (entry.getValue() == getCondition) {
                if (!breakpoint.hasCondition()) continue;
                buffer.append(BreakpointParser.serializePair(CONDITION_TYPE_ID, BreakpointParser.safeInvoke(breakpoint, getConditionType, new Object[0])));
                buffer.append(PAIR_SEPARATOR);
                buffer.append(BreakpointParser.serializePair(CONDITION_ID, BreakpointParser.safeInvoke(breakpoint, getCondition, new Object[0])));
                buffer.append(PAIR_SEPARATOR);
                continue;
            }
            Object value = BreakpointParser.safeInvoke(breakpoint, entry.getValue(), new Object[0]);
            assert (value != null);
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    buffer.append(BreakpointParser.serializePair(entry.getKey(), Array.get(value, i)));
                    buffer.append(PAIR_SEPARATOR);
                }
                continue;
            }
            buffer.append(BreakpointParser.serializePair(entry.getKey(), value));
            buffer.append(PAIR_SEPARATOR);
        }
        buffer.setLength(buffer.length() - PAIR_SEPARATOR.length());
        return buffer.toString();
    }

    public static BreakpointSpecification deserialize(BreakpointType type, String breakpoint) {
        return BreakpointParser.deserialize(BreakpointParser.serializePair(TYPE_ID, (Object)type) + PAIR_SEPARATOR + NAME_ID + KEY_VALUE_SEPARATOR + breakpoint);
    }

    public static BreakpointSpecification deserialize(String breakpoint) {
        int prefixLength = ESCAPED_PAIR_SEPARATOR.length() - PAIR_SEPARATOR.length();
        String current = breakpoint;
        int index = 0;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Map<String, Method> setters = null;
        while ((index = current.indexOf(PAIR_SEPARATOR, index)) != -1) {
            int possiblePrefixStart = index - prefixLength;
            if (possiblePrefixStart >= 0 && current.indexOf(ESCAPED_PAIR_SEPARATOR, possiblePrefixStart) == possiblePrefixStart) {
                ++index;
                continue;
            }
            String pair = current.substring(0, index);
            current = current.substring(index + PAIR_SEPARATOR.length());
            index = 0;
            setters = BreakpointParser.deserializePair(breakpoint, pair, attributes, setters);
        }
        setters = BreakpointParser.deserializePair(breakpoint, current, attributes, setters);
        BreakpointType type = (BreakpointType)((Object)attributes.remove(TYPE_ID));
        if (type == null) {
            throw new IllegalArgumentException("Incorrect breakpoint (missing type attribute): " + breakpoint);
        }
        Constructor<?> constructor = BreakpointListPacketImpl.getConstructorForType(type);
        String name = (String)attributes.remove(NAME_ID);
        if (name == null) {
            throw new IllegalArgumentException("Incorrect breakpoint (missing name attribute): " + breakpoint);
        }
        try {
            Object spec = constructor.newInstance(name);
            Object condition = attributes.remove(CONDITION_ID);
            Object conditionType = attributes.remove(CONDITION_TYPE_ID);
            if (condition != null && conditionType != null) {
                Method setCondition = setters.get(CONDITION_ID);
                spec = setCondition.invoke(spec, condition, conditionType);
            }
            for (Map.Entry entry : attributes.entrySet()) {
                Method set = setters.get(entry.getKey());
                spec = set.invoke(spec, entry.getValue());
            }
            return (BreakpointSpecification)spec;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static String serializePair(String key, Object value) {
        return key + KEY_VALUE_SEPARATOR + BreakpointParser.serializeValue(value);
    }

    private static String serializeValue(Object value) {
        String v = value.toString();
        return v.replaceAll(PAIR_SEPARATOR, SERIALIZE_ESCAPED_PAIR_SEPARATOR);
    }

    private static String unescapeValue(String escapedValue) {
        return escapedValue.replaceAll(DESERIALIZE_ESCAPED_PAIR_SEPARATOR, PAIR_SEPARATOR);
    }

    private static Object deserializeValue(String value, Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (type == BreakpointLocation.class) {
            return new BreakpointLocation(value);
        }
        return value;
    }

    private static Map<String, Method> deserializePair(String breakpoint, String pair, Map<String, Object> attributes, Map<String, Method> setters) {
        int separatorStart = pair.indexOf(KEY_VALUE_SEPARATOR);
        if (separatorStart < 0) {
            throw new IllegalArgumentException("key/value pair without separator: " + pair + " (breakpoint: \"" + breakpoint + "\")");
        }
        String key = pair.substring(0, separatorStart);
        String value = BreakpointParser.unescapeValue(pair.substring(separatorStart + KEY_VALUE_SEPARATOR.length()));
        if (TYPE_ID.equals(key)) {
            assert (setters == null && attributes.get(TYPE_ID) == null);
            BreakpointType type = BreakpointType.valueOf(value.toUpperCase());
            attributes.put(TYPE_ID, (Object)type);
            return settersPerType.get((Object)type);
        }
        if (NAME_ID.equals(key)) {
            assert (attributes.get(key) == null);
            attributes.put(key, BreakpointParser.deserializeValue(value, String.class));
            return setters;
        }
        if (CONDITION_TYPE_ID.equals(key)) {
            assert (attributes.get(key) == null);
            attributes.put(key, BreakpointParser.deserializeValue(value, Boolean.TYPE));
            return setters;
        }
        if (setters == null) {
            throw new IllegalArgumentException("Serialized representation does not start with type: " + breakpoint);
        }
        Method method = setters.get(key);
        if (method == null) {
            return setters;
        }
        Class<?> targetType = method.getParameterTypes()[0];
        if (targetType.isArray()) {
            Class<?> componentType = targetType.getComponentType();
            Object oldArray = attributes.get(key);
            int length = oldArray == null ? 1 : Array.getLength(oldArray) + 1;
            Object newArray = Array.newInstance(componentType, length);
            if (oldArray != null) {
                System.arraycopy(oldArray, 0, newArray, 0, length - 1);
            }
            Array.set(newArray, length - 1, BreakpointParser.deserializeValue(value, componentType));
            attributes.put(key, newArray);
        } else {
            assert (attributes.get(key) == null);
            attributes.put(key, BreakpointParser.deserializeValue(value, targetType));
        }
        return setters;
    }

    private static Object safeInvoke(BreakpointSpecification object, Method method, Object ... args) {
        try {
            return method.invoke((Object)object, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        String setPrefix = "set";
        ArrayList<String> getterPrefixes = new ArrayList<String>();
        getterPrefixes.add("is");
        getterPrefixes.add("get");
        for (BreakpointType type : BreakpointType.values()) {
            Class<?> clazz = BreakpointListPacketImpl.getConstructorForType(type).getDeclaringClass();
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap<String, Method> setters = new HashMap<String, Method>();
            Method[] methods = clazz.getMethods();
            block1: for (Method m : methods) {
                String methodName = m.getName();
                if (methodName.startsWith("set")) {
                    String attributeName = methodName.substring("set".length()).toLowerCase();
                    setters.put(attributeName, m);
                    continue;
                }
                for (String prefix : getterPrefixes) {
                    if (!methodName.startsWith(prefix)) continue;
                    String attributeName = methodName.substring(prefix.length()).toLowerCase();
                    getters.put(attributeName, m);
                    continue block1;
                }
            }
            setters.put(CONDITION_TYPE_ID, null);
            for (String name : getters.keySet().toArray(new String[getters.size()])) {
                if (setters.containsKey(name)) continue;
                getters.remove(name);
            }
            gettersPerType.put(type, getters);
            settersPerType.put(type, setters);
        }
    }
}

