/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.breakpoints;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.controller.packets.breakpoints.AbstractBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.ExceptionBreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ExceptionBreakpointSpecificationImpl
extends AbstractBreakpointSpecification
implements ExceptionBreakpointSpecification {
    private boolean notifyCaught = true;
    private boolean notifyUncaught = true;
    private boolean exceptionSubtypes = true;

    public static ExceptionBreakpointSpecificationImpl read(DataInputStream in) throws IOException {
        return new ExceptionBreakpointSpecificationImpl(in);
    }

    public ExceptionBreakpointSpecificationImpl(String name) {
        super(name);
    }

    private ExceptionBreakpointSpecificationImpl(DataInputStream in) throws IOException {
        super(in);
        this.notifyCaught = in.readBoolean();
        this.notifyUncaught = in.readBoolean();
        this.exceptionSubtypes = in.readBoolean();
        this.readOptional(in);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        this.writeMandatory(out);
        out.writeBoolean(this.notifyCaught);
        out.writeBoolean(this.notifyUncaught);
        out.writeBoolean(this.exceptionSubtypes);
        this.writeOptional(out);
    }

    @Override
    public void print(PrintStream stream) {
        super.print(stream);
        stream.println("        Caught exceptions         : " + (this.notifyCaught ? "yes" : "no"));
        stream.println("        Uncaught exceptions       : " + (this.notifyUncaught ? "yes" : "no"));
        stream.println("        Exception subtypes        : " + (this.exceptionSubtypes ? "yes" : "no"));
    }

    @Override
    public BreakpointType getType() {
        return BreakpointType.EXCEPTION;
    }

    @Override
    public boolean isNotifyOnCaught() {
        return this.notifyCaught;
    }

    @Override
    public ExceptionBreakpointSpecification setNotifyOnCaught(boolean notifyOnCaught) {
        ExceptionBreakpointSpecificationImpl clone = this.safeClone();
        clone.notifyCaught = notifyOnCaught;
        return clone;
    }

    @Override
    public boolean isNotifyOnUncaught() {
        return this.notifyUncaught;
    }

    @Override
    public ExceptionBreakpointSpecification setNotifyOnUncaught(boolean notifyOnUncaught) {
        ExceptionBreakpointSpecificationImpl clone = this.safeClone();
        clone.notifyUncaught = notifyOnUncaught;
        return clone;
    }

    @Override
    public boolean isNotifyOnSubtypes() {
        return this.exceptionSubtypes;
    }

    @Override
    public ExceptionBreakpointSpecification setNotifyOnSubtypes(boolean notifyOnSubtypes) {
        ExceptionBreakpointSpecificationImpl clone = this.safeClone();
        clone.exceptionSubtypes = notifyOnSubtypes;
        return clone;
    }

    @Override
    public String getExceptionName() {
        return this.getName();
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.exceptionSubtypes ? 0 : 1) ^ (this.notifyCaught ? 0 : 2) ^ (this.notifyUncaught ? 0 : 4);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ExceptionBreakpointSpecificationImpl other = (ExceptionBreakpointSpecificationImpl)obj;
        return this.exceptionSubtypes == other.exceptionSubtypes && this.notifyCaught == other.notifyCaught && this.notifyUncaught == other.notifyUncaught;
    }

    @Override
    public boolean equalNonDefaultAttributes(BreakpointSpecification other) {
        if (!super.equalNonDefaultAttributes(other)) {
            return false;
        }
        ExceptionBreakpointSpecificationImpl exBp = (ExceptionBreakpointSpecificationImpl)other;
        return this.exceptionSubtypes == exBp.exceptionSubtypes && this.notifyCaught == exBp.notifyCaught && this.notifyUncaught == exBp.notifyUncaught;
    }

    @Override
    protected Breakpoint createBreakpointImpl(Debugger debugger) {
        return debugger.createExceptionBreakpoint(this.getExceptionName(), this.notifyCaught, this.notifyUncaught, this.exceptionSubtypes);
    }

    private ExceptionBreakpointSpecificationImpl safeClone() {
        try {
            return (ExceptionBreakpointSpecificationImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

