/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.breakpoints;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.controller.packets.breakpoints.AbstractBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.LineBreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineBreakpointSpecificationImpl
extends AbstractBreakpointSpecification
implements LineBreakpointSpecification {
    private final String file;
    private final int lineNumber;
    private final String className;

    public static LineBreakpointSpecificationImpl read(DataInputStream in) throws IOException {
        return new LineBreakpointSpecificationImpl(in);
    }

    public LineBreakpointSpecificationImpl(String name) {
        super(name);
        this.file = LineBreakpointSpecificationImpl.parseFile(this.getName());
        this.lineNumber = LineBreakpointSpecificationImpl.parseLineNumber(this.getName());
        this.className = LineBreakpointSpecificationImpl.parseClassName(this.getName());
    }

    private LineBreakpointSpecificationImpl(DataInputStream in) throws IOException {
        super(in);
        this.readOptional(in);
        this.file = LineBreakpointSpecificationImpl.parseFile(this.getName());
        this.lineNumber = LineBreakpointSpecificationImpl.parseLineNumber(this.getName());
        this.className = LineBreakpointSpecificationImpl.parseClassName(this.getName());
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        this.writeMandatory(out);
        this.writeOptional(out);
    }

    @Override
    public BreakpointType getType() {
        return BreakpointType.LINE;
    }

    @Override
    public String getFileName() {
        return this.file;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.file.hashCode() ^ this.lineNumber ^ (this.className == null ? 0 : this.className.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LineBreakpointSpecificationImpl other = (LineBreakpointSpecificationImpl)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return this.file.equals(other.file) && this.lineNumber == other.lineNumber;
    }

    @Override
    protected Breakpoint createBreakpointImpl(Debugger debugger) {
        return debugger.createLineBreakpoint(this.file, this.lineNumber, this.className);
    }

    private static String parseFile(String name) {
        int index = name.indexOf(58);
        if (index < 0 || index == name.length() - 1) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        return name.substring(0, index);
    }

    private static int parseLineNumber(String name) {
        int index = name.indexOf(58);
        if (index < 0 || index == name.length() - 1) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        String remainder = name.substring(index + 1);
        if ((index = remainder.indexOf(58)) >= 0) {
            remainder = remainder.substring(0, index);
        }
        return Integer.parseInt(remainder);
    }

    private static String parseClassName(String name) {
        int index = name.indexOf(58);
        if (index < 0 || index == name.length() - 1) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        String remainder = name.substring(index + 1);
        index = remainder.indexOf(58);
        String clazz = null;
        if (index >= 0) {
            clazz = remainder.substring(index + 1);
        }
        return clazz;
    }
}

