/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.breakpoints;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.controller.packets.breakpoints.AbstractBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.MethodBciBreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class MethodBciBreakpointSpecificationImpl
extends AbstractBreakpointSpecification
implements MethodBciBreakpointSpecification {
    private final String method;
    private final int codeIndex;

    public static MethodBciBreakpointSpecificationImpl read(DataInputStream in) throws IOException {
        return new MethodBciBreakpointSpecificationImpl(in);
    }

    public MethodBciBreakpointSpecificationImpl(String name) {
        super(name);
        this.method = MethodBciBreakpointSpecificationImpl.parseMethod(this.getName());
        this.codeIndex = MethodBciBreakpointSpecificationImpl.parseBci(this.getName());
    }

    private MethodBciBreakpointSpecificationImpl(DataInputStream in) throws IOException {
        super(in);
        this.readOptional(in);
        this.method = MethodBciBreakpointSpecificationImpl.parseMethod(this.getName());
        this.codeIndex = MethodBciBreakpointSpecificationImpl.parseBci(this.getName());
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        this.writeMandatory(out);
        this.writeOptional(out);
    }

    @Override
    public BreakpointType getType() {
        return BreakpointType.METHOD_BYTE_CODE_INDEX;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public int getByteCodeIndex() {
        return this.codeIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.codeIndex ^ this.method.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MethodBciBreakpointSpecificationImpl other = (MethodBciBreakpointSpecificationImpl)obj;
        return this.codeIndex == other.codeIndex && this.method.equals(other.method);
    }

    @Override
    protected Breakpoint createBreakpointImpl(Debugger debugger) {
        return debugger.createMethodBciBreakpoint(this.method, this.codeIndex);
    }

    private static String parseMethod(String name) {
        int index = name.indexOf(58);
        if (index < 0 || index == name.length() - 1) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        return name.substring(0, index);
    }

    private static int parseBci(String name) {
        int index = name.indexOf(58);
        if (index < 0 || index == name.length() - 1) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        return Integer.parseInt(name.substring(index + 1));
    }
}

