/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.breakpoints;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.controller.packets.breakpoints.AbstractBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.RelativeMethodLineBreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class RelativeMethodLineBreakpointSpecificationImpl
extends AbstractBreakpointSpecification
implements RelativeMethodLineBreakpointSpecification {
    private final String method;
    private final int lineNumber;

    public static RelativeMethodLineBreakpointSpecificationImpl read(DataInputStream in) throws IOException {
        return new RelativeMethodLineBreakpointSpecificationImpl(in);
    }

    public RelativeMethodLineBreakpointSpecificationImpl(String name) {
        super(name);
        this.method = RelativeMethodLineBreakpointSpecificationImpl.parseMethod(this.getName());
        this.lineNumber = RelativeMethodLineBreakpointSpecificationImpl.parseLineNumber(this.getName());
    }

    private RelativeMethodLineBreakpointSpecificationImpl(DataInputStream in) throws IOException {
        super(in);
        this.readOptional(in);
        this.method = RelativeMethodLineBreakpointSpecificationImpl.parseMethod(this.getName());
        this.lineNumber = RelativeMethodLineBreakpointSpecificationImpl.parseLineNumber(this.getName());
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        this.writeMandatory(out);
        this.writeOptional(out);
    }

    @Override
    public BreakpointType getType() {
        return BreakpointType.RELATIVE_METHOD_LINE;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.lineNumber ^ this.method.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        RelativeMethodLineBreakpointSpecificationImpl other = (RelativeMethodLineBreakpointSpecificationImpl)obj;
        return this.lineNumber == other.lineNumber && this.method.equals(other.method);
    }

    @Override
    protected Breakpoint createBreakpointImpl(Debugger debugger) {
        return debugger.createMethodLineBreakpoint(this.method, this.lineNumber, true);
    }

    private static final String parseMethod(String name) {
        int index = name.indexOf(":+");
        if (index < 0 || index == name.length() - 2) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        return name.substring(0, index);
    }

    private static final int parseLineNumber(String name) {
        int index = name.indexOf(":+");
        if (index < 0 || index == name.length() - 2) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        return Integer.parseInt(name.substring(index + 2));
    }
}

