/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.breakpoints;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.breakpoints.SkipAllBreakpointsPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class SkipAllBreakpointsPacketImpl
implements SkipAllBreakpointsPacket {
    private final boolean skipAllBreakpoints;

    public static SkipAllBreakpointsPacketImpl read(DataInputStream in) throws IOException {
        return new SkipAllBreakpointsPacketImpl(in);
    }

    private SkipAllBreakpointsPacketImpl(DataInputStream in) throws IOException {
        this.skipAllBreakpoints = in.readBoolean();
    }

    public SkipAllBreakpointsPacketImpl(boolean skipAllBreakpoints) {
        this.skipAllBreakpoints = skipAllBreakpoints;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.SKIP_ALL_BREAKPOINTS;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeBoolean(this.skipAllBreakpoints);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    skip all breakpoints : " + this.skipAllBreakpoints);
    }

    @Override
    public boolean skipAllBreakpoints() {
        return this.skipAllBreakpoints;
    }

    public int hashCode() {
        return this.skipAllBreakpoints ? 1 : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SkipAllBreakpointsPacketImpl other = (SkipAllBreakpointsPacketImpl)obj;
        return this.skipAllBreakpoints == other.skipAllBreakpoints;
    }
}

