/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.breakpoints;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.controller.packets.breakpoints.AbstractBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.TypeLineBreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class TypeLineBreakpointSpecificationImpl
extends AbstractBreakpointSpecification
implements TypeLineBreakpointSpecification {
    private final String className;
    private final int lineNumber;

    public static TypeLineBreakpointSpecificationImpl read(DataInputStream in) throws IOException {
        return new TypeLineBreakpointSpecificationImpl(in);
    }

    public TypeLineBreakpointSpecificationImpl(String name) {
        super(name);
        this.className = TypeLineBreakpointSpecificationImpl.parseClassName(this.getName());
        this.lineNumber = TypeLineBreakpointSpecificationImpl.parseLineNumber(this.getName());
    }

    private TypeLineBreakpointSpecificationImpl(DataInputStream in) throws IOException {
        super(in);
        this.readOptional(in);
        this.className = TypeLineBreakpointSpecificationImpl.parseClassName(this.getName());
        this.lineNumber = TypeLineBreakpointSpecificationImpl.parseLineNumber(this.getName());
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        this.writeMandatory(out);
        this.writeOptional(out);
    }

    @Override
    public BreakpointType getType() {
        return BreakpointType.TYPE_LINE;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.className.hashCode() ^ this.lineNumber;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        TypeLineBreakpointSpecificationImpl other = (TypeLineBreakpointSpecificationImpl)obj;
        return this.className.equals(other.className) && this.lineNumber == other.lineNumber;
    }

    @Override
    protected Breakpoint createBreakpointImpl(Debugger debugger) {
        return debugger.createTypeLineBreakpoint(this.lineNumber, this.className);
    }

    private static String parseClassName(String name) {
        int index = name.indexOf(58);
        if (index < 0 || index == name.length() - 1) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        return name.substring(0, index);
    }

    private static int parseLineNumber(String name) {
        int index = name.indexOf(58);
        if (index < 0 || index == name.length() - 1) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        return Integer.parseInt(name.substring(index + 1));
    }
}

