/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.breakpoints;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.controller.packets.breakpoints.AbstractBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.breakpoints.WatchPointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class WatchPointSpecificationImpl
extends AbstractBreakpointSpecification
implements WatchPointSpecification {
    private final String className;
    private final String fieldName;
    private boolean notifyAccess = true;
    private boolean notifyModification = true;

    public static WatchPointSpecificationImpl read(DataInputStream in) throws IOException {
        return new WatchPointSpecificationImpl(in);
    }

    public WatchPointSpecificationImpl(String name) {
        super(name);
        this.className = WatchPointSpecificationImpl.parseClassName(this.getName());
        this.fieldName = WatchPointSpecificationImpl.parseFieldName(this.getName());
    }

    private WatchPointSpecificationImpl(DataInputStream in) throws IOException {
        super(in);
        this.notifyAccess = in.readBoolean();
        this.notifyModification = in.readBoolean();
        this.readOptional(in);
        this.className = WatchPointSpecificationImpl.parseClassName(this.getName());
        this.fieldName = WatchPointSpecificationImpl.parseFieldName(this.getName());
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        this.writeMandatory(out);
        out.writeBoolean(this.notifyAccess);
        out.writeBoolean(this.notifyModification);
        this.writeOptional(out);
    }

    @Override
    public void print(PrintStream stream) {
        super.print(stream);
        stream.println("        Watch field access        : " + (this.notifyAccess ? "yes" : "no"));
        stream.println("        Watch field modification  : " + (this.notifyModification ? "yes" : "no"));
    }

    @Override
    public BreakpointType getType() {
        return BreakpointType.WATCH_POINT;
    }

    @Override
    public boolean isNotifyOnAccess() {
        return this.notifyAccess;
    }

    @Override
    public WatchPointSpecification setNotifyOnAccess(boolean notifyOnAccess) {
        WatchPointSpecificationImpl clone = this.safeClone();
        clone.notifyAccess = notifyOnAccess;
        return clone;
    }

    @Override
    public boolean isNotifyOnModification() {
        return this.notifyModification;
    }

    @Override
    public WatchPointSpecification setNotifyOnModification(boolean notifyOnModification) {
        WatchPointSpecificationImpl clone = this.safeClone();
        clone.notifyModification = notifyOnModification;
        return clone;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.className.hashCode() ^ this.fieldName.hashCode() ^ (this.notifyAccess ? 0 : 1) ^ (this.notifyModification ? 0 : 2);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        WatchPointSpecificationImpl other = (WatchPointSpecificationImpl)obj;
        return this.className.equals(other.className) && this.fieldName.equals(other.fieldName) && this.notifyAccess == other.notifyAccess && this.notifyModification == other.notifyModification;
    }

    @Override
    public boolean equalNonDefaultAttributes(BreakpointSpecification other) {
        if (!super.equalNonDefaultAttributes(other)) {
            return false;
        }
        WatchPointSpecificationImpl wp = (WatchPointSpecificationImpl)other;
        return this.notifyAccess == wp.notifyAccess && this.notifyModification == wp.notifyModification;
    }

    @Override
    protected Breakpoint createBreakpointImpl(Debugger debugger) {
        return debugger.createWatchPoint(this.className, this.fieldName, this.notifyAccess, this.notifyModification);
    }

    private WatchPointSpecificationImpl safeClone() {
        try {
            return (WatchPointSpecificationImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static String parseClassName(String name) {
        int index = name.lastIndexOf(46);
        if (index < 0 || index == name.length() - 1) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        return name.substring(0, index);
    }

    private static String parseFieldName(String name) {
        int index = name.lastIndexOf(46);
        if (index < 0 || index == name.length() - 1) {
            throw new IllegalArgumentException("Illegal format: " + name);
        }
        return name.substring(index + 1);
    }
}

