/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.variables.VariableExpansionPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableTreeNodeImpl;
import com.sap.jvm.debugging.presentation.VariableTreeNode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public abstract class AbstractVariableExpansionPacket
implements VariableExpansionPacket {
    private final long threadId;
    private final int frameIndex;
    private final boolean isExpanded;
    private final VariableTreeNodeImpl[] nodes;

    protected AbstractVariableExpansionPacket(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
        this.frameIndex = in.readInt();
        this.isExpanded = in.readBoolean();
        int size = in.readInt();
        this.nodes = new VariableTreeNodeImpl[size];
        for (int i = 0; i < size; ++i) {
            this.nodes[i] = new VariableTreeNodeImpl(in);
        }
    }

    public AbstractVariableExpansionPacket(long threadId, int frameIndex, boolean isExpanded, VariableTreeNodeImpl[] nodes) {
        this.threadId = threadId;
        this.frameIndex = frameIndex;
        this.isExpanded = isExpanded;
        this.nodes = nodes;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
        out.writeInt(this.frameIndex);
        out.writeBoolean(this.isExpanded);
        out.writeInt(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].write(out);
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
        stream.println("    Stack frame index             : " + this.frameIndex);
        stream.println("    Expand node                   : " + (this.isExpanded ? "yes" : "no"));
        stream.println("    Tree path:");
        String indent = "    ";
        for (int i = 0; i < this.nodes.length; ++i) {
            indent = indent + "    ";
            this.nodes[i].print(stream, indent);
        }
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public VariableTreeNode[] getPath() {
        return (VariableTreeNode[])this.nodes.clone();
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    public int hashCode() {
        return (int)(this.threadId >> 32 ^ this.threadId) ^ this.frameIndex ^ (this.isExpanded ? 1 : 0) ^ Arrays.hashCode(this.nodes);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVariableExpansionPacket other = (AbstractVariableExpansionPacket)obj;
        return this.threadId == other.threadId && this.frameIndex == other.frameIndex && this.isExpanded == other.isExpanded && Arrays.equals(this.nodes, other.nodes);
    }
}

