/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.variables.VariableFilterPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public abstract class AbstractVariableFilterPacket
implements VariableFilterPacket {
    private final boolean showStatics;
    private final boolean showConstants;
    private final boolean showSyntheticVariables;
    private final boolean showLogicalStructures;

    protected AbstractVariableFilterPacket(DataInputStream in) throws IOException {
        this.showStatics = in.readBoolean();
        this.showConstants = in.readBoolean();
        this.showSyntheticVariables = in.readBoolean();
        this.showLogicalStructures = in.readBoolean();
    }

    public AbstractVariableFilterPacket(boolean showStatics, boolean showConstants, boolean showSyntheticVariables, boolean showLogicalStructures) {
        this.showStatics = showStatics;
        this.showConstants = showConstants;
        this.showSyntheticVariables = showSyntheticVariables;
        this.showLogicalStructures = showLogicalStructures;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeBoolean(this.showStatics);
        out.writeBoolean(this.showConstants);
        out.writeBoolean(this.showSyntheticVariables);
        out.writeBoolean(this.showLogicalStructures);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Show static fields            : " + (this.showStatics ? "yes" : "no"));
        stream.println("    Show constants                : " + (this.showConstants ? "yes" : "no"));
        stream.println("    Show synthetic variables      : " + (this.showSyntheticVariables ? "yes" : "no"));
        stream.println("    Show logical structures       : " + (this.showLogicalStructures ? "yes" : "no"));
    }

    @Override
    public boolean showStatics() {
        return this.showStatics;
    }

    @Override
    public boolean showConstants() {
        return this.showConstants;
    }

    @Override
    public boolean showSyntheticVariables() {
        return this.showSyntheticVariables;
    }

    @Override
    public boolean showLogicalStructure() {
        return this.showLogicalStructures;
    }

    public int hashCode() {
        return (this.showStatics ? 1 : 0) | (this.showConstants ? 2 : 0) | (this.showSyntheticVariables ? 4 : 0) | (this.showLogicalStructures ? 8 : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVariableFilterPacket other = (AbstractVariableFilterPacket)obj;
        return this.showStatics == other.showStatics && this.showConstants == other.showConstants && this.showSyntheticVariables == other.showSyntheticVariables && this.showLogicalStructures == other.showLogicalStructures;
    }
}

