/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.variables.VariableSelectPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableTreeNodeImpl;
import com.sap.jvm.debugging.presentation.VariableTreeNode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public abstract class AbstractVariableSelectPacket
implements VariableSelectPacket {
    private final long threadId;
    private final int frameIndex;
    private final boolean isSelected;
    private final VariableTreeNodeImpl[][] nodes;

    protected AbstractVariableSelectPacket(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
        this.frameIndex = in.readInt();
        this.isSelected = in.readBoolean();
        int variables = in.readInt();
        this.nodes = new VariableTreeNodeImpl[variables][];
        for (int i = 0; i < variables; ++i) {
            int size = in.readInt();
            this.nodes[i] = new VariableTreeNodeImpl[size];
            for (int j = 0; j < size; ++j) {
                this.nodes[i][j] = new VariableTreeNodeImpl(in);
            }
        }
    }

    public AbstractVariableSelectPacket(long threadId, int frameIndex, boolean isSelected, VariableTreeNodeImpl[][] nodes) {
        this.threadId = threadId;
        this.frameIndex = frameIndex;
        this.isSelected = isSelected;
        this.nodes = nodes;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
        out.writeInt(this.frameIndex);
        out.writeBoolean(this.isSelected);
        out.writeInt(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            out.writeInt(this.nodes[i].length);
            for (int j = 0; j < this.nodes[i].length; ++j) {
                this.nodes[i][j].write(out);
            }
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
        stream.println("    Stack frame index             : " + this.frameIndex);
        stream.println("    Select node                   : " + (this.isSelected ? "yes" : "no"));
        for (int i = 0; i < this.nodes.length; ++i) {
            stream.println("    " + (i + 1) + ". Tree path:");
            String indent = "    ";
            for (int j = 0; j < this.nodes[i].length; ++j) {
                indent = indent + "    ";
                this.nodes[i][j].print(stream, indent);
            }
        }
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public int getPathCount() {
        return this.nodes.length;
    }

    @Override
    public VariableTreeNode[] getPath(int index) {
        return (VariableTreeNode[])this.nodes[index].clone();
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    public int hashCode() {
        return (int)(this.threadId >> 32 ^ this.threadId) ^ this.frameIndex ^ (this.isSelected ? 1 : 0) ^ Arrays.deepHashCode((Object[])this.nodes);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVariableSelectPacket other = (AbstractVariableSelectPacket)obj;
        return this.threadId == other.threadId && this.frameIndex == other.frameIndex && this.isSelected == other.isSelected && Arrays.deepEquals((Object[])this.nodes, (Object[])other.nodes);
    }
}

