/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.variables.VariableSetExpressionPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableTreeNodeImpl;
import com.sap.jvm.debugging.presentation.VariableTreeNode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public abstract class AbstractVariableSetExpressionPacket
implements VariableSetExpressionPacket {
    private final long threadId;
    private final int frameIndex;
    private final String expression;
    private final VariableTreeNodeImpl[] nodes;

    protected AbstractVariableSetExpressionPacket(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
        this.frameIndex = in.readInt();
        this.expression = in.readUTF();
        int size = in.readInt();
        this.nodes = new VariableTreeNodeImpl[size];
        for (int i = 0; i < size; ++i) {
            this.nodes[i] = new VariableTreeNodeImpl(in);
        }
    }

    public AbstractVariableSetExpressionPacket(long threadId, int frameIndex, String expression, VariableTreeNodeImpl[] nodes) {
        this.threadId = threadId;
        this.frameIndex = frameIndex;
        this.expression = expression;
        this.nodes = nodes;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
        out.writeInt(this.frameIndex);
        out.writeUTF(this.expression);
        out.writeInt(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].write(out);
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
        stream.println("    Stack frame index             : " + this.frameIndex);
        stream.println("    Expression to set             : " + this.expression);
        stream.println("    Tree path:");
        String indent = "    ";
        for (int i = 0; i < this.nodes.length; ++i) {
            indent = indent + "    ";
            this.nodes[i].print(stream, indent);
        }
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public VariableTreeNode[] getPath() {
        return this.nodes;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public int hashCode() {
        return (int)(this.threadId >> 32 ^ this.threadId) ^ this.frameIndex ^ (this.expression == null ? 37 : this.expression.hashCode()) ^ Arrays.hashCode(this.nodes);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVariableSetExpressionPacket other = (AbstractVariableSetExpressionPacket)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return this.threadId == other.threadId && this.frameIndex == other.frameIndex && Arrays.equals(this.nodes, other.nodes);
    }
}

