/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.variables.VariableSetPacket;
import com.sap.jvm.debugging.controller.packets.variables.VariableTreeNodeImpl;
import com.sap.jvm.debugging.presentation.VariableTreeNode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public abstract class AbstractVariableSetPacket
implements VariableSetPacket {
    private final long threadId;
    private final int frameIndex;
    private final String value;
    private final VariableTreeNodeImpl[] nodes;

    protected AbstractVariableSetPacket(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
        this.frameIndex = in.readInt();
        this.value = in.readUTF();
        int size = in.readInt();
        this.nodes = new VariableTreeNodeImpl[size];
        for (int i = 0; i < size; ++i) {
            this.nodes[i] = new VariableTreeNodeImpl(in);
        }
    }

    public AbstractVariableSetPacket(long threadId, int frameIndex, String value, VariableTreeNodeImpl[] nodes) {
        this.threadId = threadId;
        this.frameIndex = frameIndex;
        this.value = value;
        this.nodes = nodes;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
        out.writeInt(this.frameIndex);
        out.writeUTF(this.value);
        out.writeInt(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].write(out);
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
        stream.println("    Stack frame index             : " + this.frameIndex);
        stream.println("    Value to set                  : " + this.value);
        stream.println("    Tree path:");
        String indent = "    ";
        for (int i = 0; i < this.nodes.length; ++i) {
            indent = indent + "    ";
            this.nodes[i].print(stream, indent);
        }
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public VariableTreeNode[] getPath() {
        return (VariableTreeNode[])this.nodes.clone();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.threadId >> 32 ^ this.threadId) ^ this.frameIndex ^ (this.value == null ? 37 : this.value.hashCode()) ^ Arrays.hashCode(this.nodes);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVariableSetPacket other = (AbstractVariableSetPacket)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.threadId == other.threadId && this.frameIndex == other.frameIndex && Arrays.equals(this.nodes, other.nodes);
    }
}

