/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.AddDetailFormattersPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;

public final class AddDetailFormattersPacketImpl
implements AddDetailFormattersPacket {
    private final String[] classNames;
    private final String[] expressions;

    public static AddDetailFormattersPacketImpl read(DataInputStream in) throws IOException {
        return new AddDetailFormattersPacketImpl(in);
    }

    private AddDetailFormattersPacketImpl(DataInputStream in) throws IOException {
        int size = in.readInt();
        this.classNames = new String[size];
        this.expressions = new String[size];
        for (int i = 0; i < size; ++i) {
            this.classNames[i] = in.readUTF();
            this.expressions[i] = in.readUTF();
        }
    }

    public AddDetailFormattersPacketImpl(Map<String, String> formatters) {
        this.classNames = new String[formatters.size()];
        this.expressions = new String[formatters.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : formatters.entrySet()) {
            this.classNames[i] = entry.getKey();
            this.expressions[i] = entry.getValue();
            ++i;
        }
    }

    public AddDetailFormattersPacketImpl(String[] classNames, String[] expressions) {
        if (classNames.length != expressions.length) {
            throw new IllegalArgumentException("Number of class names (" + classNames.length + ") and expressions (" + expressions.length + ") must be the same");
        }
        this.classNames = (String[])classNames.clone();
        this.expressions = (String[])expressions.clone();
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.ADD_DETAIL_FORMATTERS_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        assert (this.classNames.length == this.expressions.length);
        out.writeInt(this.classNames.length);
        for (int i = 0; i < this.classNames.length; ++i) {
            out.writeUTF(this.classNames[i]);
            out.writeUTF(this.expressions[i]);
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        for (int i = 0; i < this.classNames.length; ++i) {
            stream.println("    " + i + ". Detail Formatter            : " + this.classNames[i]);
            stream.println("    Expression                    : " + this.expressions[i]);
        }
    }

    @Override
    public int getNumberOfFormatters() {
        assert (this.classNames.length == this.expressions.length);
        return this.classNames.length;
    }

    @Override
    public String getClassName(int index) {
        return this.classNames[index];
    }

    @Override
    public String getExpression(int index) {
        return this.expressions[index];
    }

    public int hashCode() {
        return Arrays.hashCode(this.classNames) ^ Arrays.hashCode(this.expressions);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddDetailFormattersPacketImpl other = (AddDetailFormattersPacketImpl)obj;
        return Arrays.equals(this.classNames, other.classNames) && Arrays.equals(this.expressions, other.expressions);
    }
}

