/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.AddLogicalStructuresPacket;
import com.sap.jvm.debugging.presentation.LogicalStructureDefinition;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public final class AddLogicalStructuresPacketImpl
implements AddLogicalStructuresPacket {
    private final LogicalStructureDefinition[] definitions;

    public static AddLogicalStructuresPacketImpl read(DataInputStream in) throws IOException {
        return new AddLogicalStructuresPacketImpl(in);
    }

    private AddLogicalStructuresPacketImpl(DataInputStream in) throws IOException {
        int size = in.readInt();
        this.definitions = new LogicalStructureDefinition[size];
        for (int i = 0; i < size; ++i) {
            this.definitions[i] = LogicalStructureDefinition.read(in);
        }
    }

    public AddLogicalStructuresPacketImpl(LogicalStructureDefinition[] definitions) {
        this.definitions = (LogicalStructureDefinition[])definitions.clone();
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.ADD_LOGICAL_STRUCTURES_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.definitions.length);
        for (int i = 0; i < this.definitions.length; ++i) {
            this.definitions[i].write(out);
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        for (int i = 0; i < this.definitions.length; ++i) {
            stream.println("    " + (i + 1) + ". Logical Structure Definition:");
            this.definitions[i].print(stream);
        }
    }

    @Override
    public int getNumberOfLogicalStructures() {
        return this.definitions.length;
    }

    @Override
    public LogicalStructureDefinition getStructure(int index) {
        return this.definitions[index];
    }

    public int hashCode() {
        return Arrays.hashCode(this.definitions);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddLogicalStructuresPacketImpl other = (AddLogicalStructuresPacketImpl)obj;
        return Arrays.equals(this.definitions, other.definitions);
    }
}

